/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.creepers;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class IcyCreeperEntity
extends CreeperEntity {
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;

    public IcyCreeperEntity(World worldIn) {
        super((EntityType)ModEntityTypes.ICY_CREEPER.get(), worldIn);
    }

    public static boolean canIcyCreeperSpawn(EntityType<IcyCreeperEntity> entityType, IServerWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return IcyCreeperEntity.func_223325_c(entityType, (IServerWorld)iWorld, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || iWorld.func_226660_f_(blockPos));
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.SNOWFLAKE.get(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        super.func_70636_d();
    }

    public IcyCreeperEntity(EntityType<? extends CreeperEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return CreeperEntity.func_234278_m_();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.oldSwell = this.swell;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((i = this.func_70832_p()) > 0 && this.swell == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.25f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.func_70071_h_();
    }

    private void explodeCreeper() {
        double d2;
        double d1;
        int i;
        if (!this.field_70170_p.field_72995_K) {
            Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            float f = this.func_225509_J__() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)this.explosionRadius * f, explosion$mode);
            this.func_184185_a((SoundEvent)ModSoundEvents.ICY_CREEPER_EXPLODE.get(), 2.0f, 1.0f);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
        for (i = 0; i < 75; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.3;
            d1 = this.field_70146_Z.nextGaussian() * 0.2;
            d2 = this.field_70146_Z.nextGaussian() * 0.3;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), d0, d1, d2);
        }
        for (i = 0; i < 50; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.6;
            d1 = this.field_70146_Z.nextGaussian() * 0.3;
            d2 = this.field_70146_Z.nextGaussian() * 0.6;
            this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.SNOWFLAKE.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), d0, d1, d2);
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }
}

