/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.blaze;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildfireEntity
extends MonsterEntity
implements IAnimatable,
SpawnArmoredMob {
    private static final DataParameter<Integer> SHIELDS = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SHIELD_HEALTH = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final Predicate<Entity> NO_BLAZE_AND_ALIVE = p_213685_0_ -> p_213685_0_.func_70089_S() && !(p_213685_0_ instanceof BlazeEntity) && !(p_213685_0_ instanceof WildfireEntity);
    public int shootAnimationTick;
    public int shootAnimationLength = 12;
    public int shootAnimationActionPoint = 5;
    public int shockwaveAnimationTick;
    public int shockwaveAnimationLength = 27;
    public int shockwaveAnimationActionPoint = 9;
    public int summonAnimationTick;
    public int summonAnimationLength = 47;
    public int summonAnimationActionPoint = 15;
    public int soundLoopTick;
    public int regenerateShieldTick;
    public int regenerateShieldTime = 150;
    public float individualShieldHealth = 15.0f;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WildfireEntity(EntityType<? extends WildfireEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 25;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 6.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new ShockwaveAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SummonBlazesGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ApproachTargetGoal((CreatureEntity)this, 10.0, 1.2, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
    }

    private void shockwave() {
        if (this.func_70089_S()) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0), NO_BLAZE_AND_ALIVE)) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 7.0f);
                entity.func_70015_d(3);
                this.strongKnockback(entity);
            }
        }
    }

    private void strongKnockback(Entity p_213688_1_) {
        double d0 = p_213688_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_213688_1_.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.func_70024_g(d0 / d2 * 3.0, 0.2, d1 / d2 * 3.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, ILivingEntityData p_213386_4_, CompoundNBT p_213386_5_) {
        this.setShieldHealth(this.individualShieldHealth * 4.0f);
        this.setShields(4);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        SpawnArmoredHelper.equipArmorSet(ModItems.NETHERPLATE_ARMOR, (MobEntity)this);
    }

    public int getShields() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(SHIELDS)), (int)0, (int)4);
    }

    public void setShields(int p_191997_1_) {
        this.field_70180_af.func_187227_b(SHIELDS, (Object)p_191997_1_);
    }

    public float getShieldHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SHIELD_HEALTH)).floatValue();
    }

    public void setShieldHealth(float p_191997_1_) {
        this.field_70180_af.func_187227_b(SHIELD_HEALTH, (Object)Float.valueOf(p_191997_1_));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDS, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_HEALTH, (Object)Float.valueOf(0.0f));
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Shields", this.getShields());
        p_213281_1_.func_74776_a("ShieldHealth", this.getShieldHealth());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setShields(p_70037_1_.func_74762_e("Shields"));
        this.setShieldHealth(p_70037_1_.func_74760_g("ShieldHealth"));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.getShields() > 0 && p_184601_1_ != DamageSource.field_76380_i && p_184601_1_ != DamageSource.field_76369_e ? SoundEvents.field_187603_D : (SoundEvent)ModSoundEvents.WILDFIRE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_DEATH.get();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_MOVE.get(), 0.15f, 1.0f);
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 11) {
            this.shockwaveAnimationTick = this.shockwaveAnimationLength;
        } else if (p_28844_ == 9) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.getShields() > 0 && p_70097_1_ != DamageSource.field_76380_i && p_70097_1_ != DamageSource.field_76369_e) {
            if (p_70097_1_.func_76346_g() != null && p_70097_1_.func_76346_g() instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)p_70097_1_.func_76346_g());
            }
            this.setShieldHealth(this.getShieldHealth() - p_70097_2_);
            if (this.getShieldHealth() < this.individualShieldHealth * 3.0f && this.getShields() > 3 || this.getShieldHealth() < this.individualShieldHealth * 2.0f && this.getShields() > 2 || this.getShieldHealth() < this.individualShieldHealth * 1.0f && this.getShields() > 1 || this.getShieldHealth() <= this.individualShieldHealth * 0.0f && this.getShields() > 0) {
                this.breakShield();
            } else {
                this.func_184581_c(p_70097_1_);
            }
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    boolean steepDropBelow() {
        boolean blockBeneath = false;
        for (int i = 0; i < 8; ++i) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o() - i, this.func_233580_cy_().func_177952_p())).func_196958_f()) continue;
            blockBeneath = true;
        }
        return !this.field_70170_p.field_72995_K && !blockBeneath;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.getShields() < 4 && this.regenerateShieldTick > 0) {
            --this.regenerateShieldTick;
            if (this.regenerateShieldTick == 0) {
                this.regenerateShield();
            }
        }
        if (this.getShields() > 0 && this.getShieldHealth() <= 0.0f) {
            this.breakShield();
        }
        if (this.func_70638_az() != null && (!this.func_233570_aj_() && this.steepDropBelow() || this.func_70638_az().func_226278_cu_() > this.func_226278_cu_() + 3.0 || this.func_226278_cu_() < this.func_70638_az().func_226278_cu_() || this.func_70032_d((Entity)this.func_70638_az()) > 15.0f)) {
            if (this.func_226278_cu_() < this.func_70638_az().func_226278_cu_() + 5.0) {
                this.func_213293_j(0.0, 0.04, 0.0);
            } else {
                this.func_213293_j(0.0, -0.01, 0.0);
            }
            double x = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
            double y = this.func_70638_az().func_226278_cu_() - this.func_226278_cu_();
            double z = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.func_213317_d(this.func_213322_ci().func_72441_c(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).func_186678_a(0.4));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226280_cw_(), this.func_70638_az().func_226281_cx_()));
        }
        ++this.soundLoopTick;
        if (this.soundLoopTick % 100 == 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_IDLE_LOOP.get(), 0.5f, 1.0f);
        }
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.3, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public void breakShield() {
        this.regenerateShieldTick = this.regenerateShieldTime;
        this.setShields(this.getShields() - 1);
        this.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_SHIELD_BREAK.get(), 1.0f, 1.0f);
    }

    public void regenerateShield() {
        this.setShields(this.getShields() + 1);
        this.setShieldHealth(this.getShieldHealth() + this.individualShieldHealth);
        this.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_SHOOT.get(), 1.0f, 1.0f);
        this.regenerateShieldTick = this.regenerateShieldTime;
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.shockwaveAnimationTick > 0) {
            --this.shockwaveAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.shockwaveAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_shockwave", Boolean.valueOf(true)));
        } else if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_summon", Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_shoot", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ArmorSet getArmorSet() {
        return ModItems.NETHERPLATE_ARMOR;
    }

    class ShootAttackGoal
    extends Goal {
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(WildfireEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70146_Z.nextInt(15) == 0 && this.mob.func_70032_d((Entity)this.target) > 4.0f && this.mob.func_70032_d((Entity)this.target) < 13.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                double d1 = this.target.func_226277_ct_() - this.mob.func_226277_ct_();
                double d2 = this.target.func_226283_e_(0.5) - this.mob.func_226283_e_(0.75);
                double d3 = this.target.func_226281_cx_() - this.mob.func_226281_cx_();
                SmallFireballEntity smallfireballentity = new SmallFireballEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1, d2, d3);
                smallfireballentity.func_70107_b(smallfireballentity.func_226277_ct_(), this.mob.func_226283_e_(0.5) + 0.5, smallfireballentity.func_226281_cx_());
                this.mob.field_70170_p.func_217376_c((Entity)smallfireballentity);
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class ShockwaveAttackGoal
    extends Goal {
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;

        public ShockwaveAttackGoal(WildfireEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_233570_aj_() && this.mob.field_70146_Z.nextInt(20) == 0 && this.mob.func_70032_d((Entity)this.target) < 4.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_SHOCKWAVE.get(), 1.0f, this.mob.func_70647_i());
            this.mob.shockwaveAnimationTick = this.mob.shockwaveAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.shockwaveAnimationTick == this.mob.shockwaveAnimationActionPoint) {
                this.mob.shockwave();
            }
        }

        public boolean animationsUseable() {
            return this.mob.shockwaveAnimationTick <= 0;
        }
    }

    class SummonBlazesGoal
    extends Goal {
        private final EntityPredicate blazeCountTargeting = new EntityPredicate().func_221013_a(30.0).func_221010_e().func_221008_a().func_221011_b();
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;
        public int blazeSummonRange = 5;
        public int closeBlazeSummonRange = 2;

        public SummonBlazesGoal(WildfireEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            int nearbyBlazes = this.mob.field_70170_p.func_217374_a(BlazeEntity.class, this.blazeCountTargeting, (LivingEntity)this.mob, this.mob.func_174813_aQ().func_186662_g(30.0)).size();
            return this.target != null && this.mob.field_70146_Z.nextInt(80 * (nearbyBlazes + 1)) == 0 && nearbyBlazes < 3 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WILDFIRE_MOVE.get(), 1.0f, this.mob.func_70647_i());
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint) {
                for (int i = 0; i < 1 + this.mob.field_70146_Z.nextInt(1); ++i) {
                    SummonSpotEntity blazeSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                    blazeSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                    blazeSummonSpot.setSummonType(1);
                    BlockPos summonPos = this.mob.func_233580_cy_().func_177982_a(-this.blazeSummonRange + this.mob.field_70146_Z.nextInt(this.blazeSummonRange * 2 + 1), 0, -this.blazeSummonRange + this.mob.field_70146_Z.nextInt(this.blazeSummonRange * 2 + 1));
                    blazeSummonSpot.func_174828_a(summonPos, 0.0f, 0.0f);
                    if (blazeSummonSpot.func_70094_T() || !this.canSee(blazeSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.func_233580_cy_().func_177982_a(-this.closeBlazeSummonRange + this.mob.field_70146_Z.nextInt(this.closeBlazeSummonRange * 2 + 1), 0, -this.closeBlazeSummonRange + this.mob.field_70146_Z.nextInt(this.closeBlazeSummonRange * 2 + 1));
                    }
                    if (blazeSummonSpot.func_70094_T() || !this.canSee(blazeSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.func_233580_cy_();
                    }
                    ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)blazeSummonSpot);
                    PositionUtils.moveToCorrectHeight(blazeSummonSpot);
                    EntityType entityType = EntityType.field_200792_f;
                    MobEntity summonedMob = null;
                    Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)blazeSummonSpot.func_233580_cy_(), (EntityType)entityType);
                    if (entity == null) {
                        blazeSummonSpot.func_70106_y();
                        return;
                    }
                    if (entity instanceof MobEntity) {
                        summonedMob = (MobEntity)entity;
                    }
                    summonedMob.func_70624_b(this.target);
                    summonedMob.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(summonPos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                    blazeSummonSpot.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                    if (this.mob.func_96124_cp() != null) {
                        Scoreboard scoreboard = this.mob.field_70170_p.func_96441_U();
                        scoreboard.func_197901_a(summonedMob.func_195047_I_(), scoreboard.func_96508_e(this.mob.func_96124_cp().func_96661_b()));
                    }
                    blazeSummonSpot.summonedEntity = summonedMob;
                }
            }
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vector3d vector3d = new Vector3d(entitySeeing.func_226277_ct_(), entitySeeing.func_226280_cw_(), entitySeeing.func_226281_cx_());
            Vector3d vector3d1 = new Vector3d(p_70685_1_.func_226277_ct_(), p_70685_1_.func_226280_cw_(), p_70685_1_.func_226281_cx_());
            if (p_70685_1_.field_70170_p != entitySeeing.field_70170_p || vector3d1.func_72436_e(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entitySeeing)).func_216346_c() == RayTraceResult.Type.MISS;
        }
    }
}

