/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.data;

import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.IEnchantable;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.data.MobAncientData;
import com.infamous.dungeons_mobs.data.MobEnchantmentAncientData;
import com.infamous.dungeons_mobs.data.UniqueAncientData;
import com.infamous.dungeons_mobs.data.util.MergeableCodecDataManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AncientDataHelper {
    public static final MergeableCodecDataManager<MobAncientData, MobAncientData> MOB_ANCIENT_DATA = new MergeableCodecDataManager<MobAncientData, MobAncientData>("ancient/mob_ancient_data", DungeonsMobs.LOGGER, MobAncientData.CODEC, AncientDataHelper::mobMerger);
    public static final MergeableCodecDataManager<MobEnchantmentAncientData, MobEnchantmentAncientData> MOB_ENCHANTMENT_ANCIENT_DATA = new MergeableCodecDataManager<MobEnchantmentAncientData, MobEnchantmentAncientData>("ancient/mob_enchantment_ancient_data", DungeonsMobs.LOGGER, MobEnchantmentAncientData.CODEC, AncientDataHelper::mobEnchantmentMerger);

    public static MobAncientData mobMerger(List<MobAncientData> raws) {
        ArrayList<String> adjectives = new ArrayList<String>();
        ArrayList<String> nouns = new ArrayList<String>();
        ArrayList<ResourceLocation> minions = new ArrayList<ResourceLocation>();
        ArrayList<UniqueAncientData> uniques = new ArrayList<UniqueAncientData>();
        raws.forEach(raw -> {
            adjectives.addAll(raw.getAdjectives());
            nouns.addAll(raw.getNouns());
            minions.addAll(raw.getMinions());
            uniques.addAll(raw.getUniques());
        });
        return new MobAncientData(adjectives, nouns, minions, uniques);
    }

    public static MobEnchantmentAncientData mobEnchantmentMerger(List<MobEnchantmentAncientData> raws) {
        ArrayList<String> adjectives = new ArrayList<String>();
        ArrayList<String> nouns = new ArrayList<String>();
        raws.forEach(raw -> {
            adjectives.addAll(raw.getAdjectives());
            nouns.addAll(raw.getNouns());
        });
        return new MobEnchantmentAncientData(adjectives, nouns);
    }

    public static MobAncientData getMobAncientData(ResourceLocation mobResourceLocation) {
        return AncientDataHelper.MOB_ANCIENT_DATA.data.getOrDefault(mobResourceLocation, MobAncientData.DEFAULT);
    }

    public static MobEnchantmentAncientData getMobEnchantmentAncientData(ResourceLocation mobEnchantmentResourceLocation) {
        return AncientDataHelper.MOB_ENCHANTMENT_ANCIENT_DATA.data.getOrDefault(mobEnchantmentResourceLocation, MobEnchantmentAncientData.DEFAULT);
    }

    public static String getAncientName(LivingEntity entity) {
        HashSet<String> adjectives = new HashSet<String>();
        HashSet<String> nouns = new HashSet<String>();
        IEnchantable enchantCap = EnchantableHelper.getEnchantableCapability((Entity)entity);
        enchantCap.getEnchantments().forEach(mobEnchantment -> {
            MobEnchantmentAncientData mobEnchantmentAncientData = AncientDataHelper.getMobEnchantmentAncientData(mobEnchantment.getRegistryName());
            adjectives.addAll(mobEnchantmentAncientData.getAdjectives());
            nouns.addAll(mobEnchantmentAncientData.getNouns());
        });
        MobAncientData mobAncientData = AncientDataHelper.getMobAncientData(entity.func_200600_R().getRegistryName());
        adjectives.addAll(mobAncientData.getAdjectives());
        nouns.addAll(mobAncientData.getNouns());
        return (String)new ArrayList(adjectives).get(entity.func_70681_au().nextInt(adjectives.size())) + " " + (String)new ArrayList(nouns).get(entity.func_70681_au().nextInt(nouns.size()));
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(MOB_ANCIENT_DATA);
    }
}

