/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.water;

import com.infamous.dungeons_mobs.client.models.undead.SunkenSkeletonModel;
import com.infamous.dungeons_mobs.entities.water.SunkenSkeletonEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunkenSkeletonRenderer<T extends SunkenSkeletonEntity>
extends BipedRenderer<T, SunkenSkeletonModel<T>> {
    private static final ResourceLocation SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/sunken_skeleton.png");
    private static final ResourceLocation RED_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/red_coral_armored_sunken_skeleton.png");
    private static final ResourceLocation YELLOW_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/yellow_coral_armored_sunken_skeleton.png");
    private static final List<ResourceLocation> ARMORED_SKELETON_LOCATIONS = Arrays.asList(RED_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION, YELLOW_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION);

    public SunkenSkeletonRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new SunkenSkeletonModel(), 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new SunkenSkeletonModel(0.5f, true), new SunkenSkeletonModel(1.0f, true)));
    }

    protected void scale(T skeleton, MatrixStack matrixStack, float v) {
        super.func_225620_a_(skeleton, matrixStack, v);
    }

    protected void setupRotations(T skeleton, MatrixStack matrixStack, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
        super.func_225621_a_(skeleton, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
        float swimAmount = skeleton.func_205015_b(p_225621_5_);
        if (swimAmount > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)swimAmount, (float)((SunkenSkeletonEntity)skeleton).field_70125_A, (float)(-10.0f - ((SunkenSkeletonEntity)skeleton).field_70125_A))));
        }
    }

    public ResourceLocation getTextureLocation(T skeleton) {
        return SUNKEN_SKELETON_LOCATION;
    }
}

