/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.util;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.client.renderer.util.IGeoReplacedEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import software.bernie.geckolib3.compat.PatchouliCompat;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModGeoReplacedEntityRenderer<T extends IAnimatable>
extends EntityRenderer
implements IGeoRenderer {
    final AnimatedGeoModel<IAnimatable> modelProvider;
    protected final T animatable;
    protected IRenderTypeBuffer rtb;
    protected ItemStack mainHand;
    protected ItemStack offHand;
    protected ItemStack helmet;
    protected ItemStack chestplate;
    protected ItemStack leggings;
    protected ItemStack boots;
    protected ResourceLocation whTexture;
    protected final List<GeoLayerRenderer> layerRenderers = Lists.newArrayList();
    protected IAnimatable currentAnimatable;
    protected LivingEntity currentEntity;
    protected static final Map<Class<? extends IAnimatable>, ModGeoReplacedEntityRenderer> renderers = new ConcurrentHashMap<Class<? extends IAnimatable>, ModGeoReplacedEntityRenderer>();

    public ModGeoReplacedEntityRenderer(EntityRendererManager renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        super(renderManager);
        this.modelProvider = modelProvider;
        this.animatable = animatable;
        if (!renderers.containsKey(animatable.getClass())) {
            renderers.put(animatable.getClass(), this);
        }
    }

    public static ModGeoReplacedEntityRenderer getRenderer(Class<? extends IAnimatable> item) {
        return renderers.get(item);
    }

    public void func_225623_a_(Entity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.render(entityIn, (IAnimatable)this.animatable, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public void renderEarly(Object animatable, MatrixStack stackIn, float partialTicks, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.rtb = renderTypeBuffer;
        Matrix4f renderEarlyMat = stackIn.func_227866_c_().func_227870_a_().func_226601_d_();
        super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction direction;
        Entity leashHolder;
        this.currentAnimatable = animatable;
        IAnimatable geo = animatable;
        if (!(entity instanceof LivingEntity)) {
            throw new RuntimeException("Replaced renderer was not an instanceof LivingEntity");
        }
        LivingEntity entityLiving = (LivingEntity)entity;
        this.mainHand = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.MAINHAND);
        this.offHand = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.OFFHAND);
        this.helmet = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.HEAD);
        this.chestplate = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.CHEST);
        this.leggings = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.LEGS);
        this.boots = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.FEET);
        this.whTexture = this.getTextureLocation(animatable);
        this.currentEntity = entityLiving;
        if (animatable instanceof IGeoReplacedEntity) {
            IGeoReplacedEntity z = (IGeoReplacedEntity)geo;
            if (entity instanceof MobEntity) {
                z.setMobEntity((MobEntity)entity);
            }
        }
        stack.func_227860_a_();
        if (entity instanceof MobEntity && (leashHolder = ((MobEntity)entity).func_110166_bE()) != null) {
            this.renderLeash((MobEntity)entity, partialTicks, stack, bufferIn, leashHolder);
        }
        boolean shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entityLiving.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityLiving.field_70760_ar, (float)entityLiving.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityLiving.field_70758_at, (float)entityLiving.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70125_A, (float)entity.field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entityLiving.func_213376_dz()) != null) {
            float f4 = entity.func_213307_e(Pose.STANDING) - 0.1f;
            stack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = this.handleRotationFloat(entityLiving, partialTicks);
        this.applyRotations(entityLiving, stack, f7, f, partialTicks);
        this.preRenderCallback(entityLiving, stack, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entityLiving.field_184618_aE, (float)entityLiving.field_70721_aZ);
            limbSwing = entityLiving.field_184619_aG - entityLiving.field_70721_aZ * (1.0f - partialTicks);
            if (entityLiving.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -f6;
        entityModelData.netHeadYaw = -f2;
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)animatable));
        AnimationEvent predicate = new AnimationEvent(animatable, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        this.modelProvider.setLivingAnimations((Object)animatable, this.getUniqueID(entity), predicate);
        stack.func_227861_a_(0.0, (double)0.01f, 0.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.func_110775_a(entity));
        Color renderColor = this.getRenderColor(animatable, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, stack, bufferIn, null, packedLightIn, this.func_110775_a(entity));
        if (!entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            IVertexBuilder translucentBuffer;
            IVertexBuilder glintBuffer = bufferIn.getBuffer(RenderType.func_239274_p_());
            this.render(model, entity, partialTicks, renderType, stack, bufferIn, glintBuffer != (translucentBuffer = bufferIn.getBuffer(RenderType.func_228642_d_((ResourceLocation)this.func_110775_a(entity)))) ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)glintBuffer, (IVertexBuilder)translucentBuffer) : null, packedLightIn, ModGeoReplacedEntityRenderer.getPackedOverlay(entityLiving, this.getOverlayProgress(entityLiving, partialTicks)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.func_175149_v()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(stack, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, f7, f2, f6);
            }
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded((MatrixStack)stack);
        }
        stack.func_227865_b_();
        super.func_225623_a_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    protected float getOverlayProgress(LivingEntity livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
    }

    public ResourceLocation func_110775_a(Entity entity) {
        return this.getTextureLocation(this.currentAnimatable);
    }

    public AnimatedGeoModel getGeoModelProvider() {
        return this.modelProvider;
    }

    public static int getPackedOverlay(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)uIn), (int)OverlayTexture.func_229202_a_((livingEntityIn.field_70737_aN > 0 || livingEntityIn.field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(LivingEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose = entityLiving.func_213283_Z();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.getDeathMaxRotation(entityLiving)));
        } else if (entityLiving.func_204805_cN()) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - entityLiving.field_70125_A));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)entityLiving.field_70173_aa + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.func_213376_dz();
            float f1 = direction != null ? ModGeoReplacedEntityRenderer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.getDeathMaxRotation(entityLiving)));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((entityLiving.func_145818_k_() || entityLiving instanceof PlayerEntity) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a((String)entityLiving.func_200200_C_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof PlayerEntity) || ((PlayerEntity)entityLiving).func_175148_a(PlayerModelPart.CAPE))) {
            matrixStackIn.func_227861_a_(0.0, (double)(entityLiving.func_213302_cg() + 0.1f), 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    protected boolean isVisible(LivingEntity livingEntityIn) {
        return !livingEntityIn.func_82150_aj();
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(LivingEntity entityLivingBaseIn) {
        return 90.0f;
    }

    public boolean func_177070_b(Entity entity) {
        float f;
        double d0 = this.field_76990_c.func_229099_b_(entity);
        float f2 = f = entity.func_226273_bm_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        return entity == this.field_76990_c.field_147941_i && entity.func_145818_k_();
    }

    protected float getSwingProgress(LivingEntity livingBase, float partialTickTime) {
        return livingBase.func_70678_g(partialTickTime);
    }

    protected float handleRotationFloat(LivingEntity livingBase, float partialTicks) {
        return (float)livingBase.field_70173_aa + partialTicks;
    }

    public ResourceLocation getTextureLocation(Object instance) {
        return this.modelProvider.getTextureLocation((Object)((IAnimatable)instance));
    }

    public <E extends Entity> void renderLeash(MobEntity entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, E leashHolder) {
        int u;
        poseStack.func_227860_a_();
        Vector3d vec3d = leashHolder.func_241843_o(partialTicks);
        double d = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70761_aq, (float)entity.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vec3d2 = entity.func_241205_ce_();
        double e = Math.cos(d) * vec3d2.field_72449_c + Math.sin(d) * vec3d2.field_72450_a;
        double f = Math.sin(d) * vec3d2.field_72449_c - Math.cos(d) * vec3d2.field_72450_a;
        double g = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_()) + e;
        double h = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_()) + vec3d2.field_72448_b;
        double i = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_()) + f;
        poseStack.func_227861_a_(e, vec3d2.field_72448_b, f);
        float j = (float)(vec3d.field_72450_a - g);
        float k = (float)(vec3d.field_72448_b - h);
        float l = (float)(vec3d.field_72449_c - i);
        IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        float n = MathHelper.func_226165_i_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.func_174824_e(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int q = this.func_225624_a_((Entity)entity, blockPos);
        int r = leashHolder.func_70027_ad() ? 15 : leashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, blockPos2);
        int s = entity.field_70170_p.func_226658_a_(LightType.SKY, blockPos);
        int t = entity.field_70170_p.func_226658_a_(LightType.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            ModGeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            ModGeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        poseStack.func_227865_b_();
    }

    private static void renderLeashPiece(IVertexBuilder vertexConsumer, Matrix4f positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)MathHelper.func_219799_g((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)MathHelper.func_219799_g((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = LightTexture.func_228451_a_((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.func_227888_a_(positionMatrix, u - k, v + j, w + l).func_227885_a_(r, s, t, 1.0f).func_227886_a_(p).func_181675_d();
        vertexConsumer.func_227888_a_(positionMatrix, u + k, v + i - j, w - l).func_227885_a_(r, s, t, 1.0f).func_227886_a_(p).func_181675_d();
    }

    public IRenderTypeBuffer getCurrentRTB() {
        return this.rtb;
    }

    public void setCurrentRTB(IRenderTypeBuffer rtb) {
        this.rtb = rtb;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            ModGeoReplacedEntityRenderer renderer = renderers.get(object.getClass());
            return renderer == null ? null : renderer.getGeoModelProvider();
        });
    }
}

