/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.util;

import com.google.common.collect.Maps;
import com.infamous.dungeons_mobs.client.renderer.util.ModGeoReplacedEntityRenderer;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public abstract class ModExtentedGeoReplacedEntityRenderer<T extends IAnimatable>
extends ModGeoReplacedEntityRenderer<T> {
    protected float widthScale;
    protected float heightScale;
    protected final Queue<Tuple<GeoBone, ItemStack>> HEAD_QUEUE = new ArrayDeque<Tuple<GeoBone, ItemStack>>();
    private software.bernie.geckolib3.util.EModelRenderCycle currentModelRenderCycle = software.bernie.geckolib3.util.EModelRenderCycle.INITIAL;
    protected final BipedModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_INNER = new BipedModel(0.5f);
    protected final BipedModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_OUTER = new BipedModel(1.0f);
    private IVertexBuilder currentVertexBuilderInUse;
    private float currentPartialTicks;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public ModExtentedGeoReplacedEntityRenderer(EntityRendererManager renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        this(renderManager, modelProvider, animatable, 1.0f, 1.0f, 0.0f);
    }

    protected ModExtentedGeoReplacedEntityRenderer(EntityRendererManager renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animation, float widthScale, float heightScale, float shadowSize) {
        super(renderManager, modelProvider, animation);
        this.field_76989_e = shadowSize;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
    }

    @Override
    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.setCurrentModelRenderCycle((software.bernie.geckolib3.util.IRenderCycle)software.bernie.geckolib3.util.EModelRenderCycle.INITIAL);
        super.render(entity, animatable, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    protected void renderHeads(MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn) {
        while (!this.HEAD_QUEUE.isEmpty()) {
            Tuple<GeoBone, ItemStack> entry = this.HEAD_QUEUE.poll();
            GeoBone bone = (GeoBone)entry.func_76341_a();
            ItemStack itemStack = (ItemStack)entry.func_76340_b();
            stack.func_227860_a_();
            this.moveAndRotateMatrixToMatchBone(stack, bone);
            GameProfile skullOwnerProfile = null;
            if (itemStack.func_77942_o()) {
                String s;
                CompoundNBT compoundnbt = itemStack.func_77978_p();
                if (compoundnbt.func_150297_b("SkullOwner", 10)) {
                    skullOwnerProfile = NBTUtil.func_152459_a((CompoundNBT)compoundnbt.func_74775_l("SkullOwner"));
                } else if (compoundnbt.func_150297_b("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)(s = compoundnbt.func_74779_i("SkullOwner")))) {
                    skullOwnerProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile((UUID)null, s));
                    compoundnbt.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)skullOwnerProfile));
                }
            }
            float sx = 1.0f;
            float sy = 1.0f;
            float sz = 1.0f;
            try {
                GeoCube firstCube = (GeoCube)bone.childCubes.get(0);
                if (firstCube != null) {
                    sx = firstCube.size.func_195899_a() / 8.0f;
                    sy = firstCube.size.func_195900_b() / 8.0f;
                    sz = firstCube.size.func_195902_c() / 8.0f;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            stack.func_227862_a_(1.1875f * sx, 1.1875f * sy, 1.1875f * sz);
            stack.func_227861_a_(-0.5, 0.0, -0.5);
            SkullTileEntityRenderer.func_228879_a_((Direction)null, (float)0.0f, (SkullBlock.ISkullType)((AbstractSkullBlock)((BlockItem)itemStack.func_77973_b()).func_179223_d()).func_196292_N_(), (GameProfile)skullOwnerProfile, (float)0.0f, (MatrixStack)stack, (IRenderTypeBuffer)buffer, (int)packedLightIn);
            stack.func_227865_b_();
        }
    }

    public void render(GeoModel model, Object animatable, float partialTicks, RenderType type, MatrixStack matrixStackIn, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.setCurrentModelRenderCycle((software.bernie.geckolib3.util.IRenderCycle)software.bernie.geckolib3.util.EModelRenderCycle.REPEATED);
        this.renderHeads(matrixStackIn, renderTypeBuffer, packedLightIn);
    }

    protected float getWidthScale(T entity) {
        return this.widthScale;
    }

    protected float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(Object animatable, MatrixStack stackIn, float partialTicks, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.rtb = renderTypeBuffer;
        super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.getCurrentModelRenderCycle() == software.bernie.geckolib3.util.EModelRenderCycle.INITIAL && animatable instanceof IAnimatable) {
            float width = this.getWidthScale((IAnimatable)animatable);
            float height = this.getHeightScale((IAnimatable)animatable);
            stackIn.func_227862_a_(width, height, width);
        }
    }

    public void renderLate(Object animatable, MatrixStack stackIn, float partialTicks, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.renderLate(animatable, stackIn, partialTicks, renderTypeBuffer, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.currentVertexBuilderInUse = bufferIn;
        this.currentPartialTicks = partialTicks;
    }

    protected abstract boolean isArmorBone(GeoBone var1);

    protected void moveAndRotateMatrixToMatchBone(MatrixStack stack, GeoBone bone) {
        stack.func_227861_a_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(bone.getRotationX()));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bone.getRotationY()));
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(bone.getRotationZ()));
    }

    protected void handleArmorRenderingForBone(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, ResourceLocation currentTexture) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ItemStack armorForBone = this.getArmorForBone(bone.getName(), this.currentAnimatable);
        EquipmentSlotType boneSlot = this.getEquipmentSlotForArmorBone(bone.getName(), this.currentAnimatable);
        if (armorForBone != null && boneSlot != null) {
            if (armorForBone.func_77973_b() instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorForBone.func_77973_b();
                BipedModel armorModel = ForgeHooksClient.getArmorModel((LivingEntity)this.currentEntity, (ItemStack)armorForBone, (EquipmentSlotType)boneSlot, boneSlot == EquipmentSlotType.LEGS ? this.DEFAULT_BIPED_ARMOR_MODEL_INNER : this.DEFAULT_BIPED_ARMOR_MODEL_OUTER);
                ModelRenderer sourceLimb = this.getArmorPartForBone(bone.getName(), armorModel);
                if (armorModel != null) {
                    ObjectList cubeList;
                    if (armorForBone.func_77973_b() instanceof GeoArmorItem) {
                        ObjectList cubeList2;
                        GeoArmorRenderer geoArmorRenderer = GeoArmorRenderer.getRenderer(armorItem.getClass(), (Entity)this.currentEntity);
                        if (sourceLimb != null && !(cubeList2 = sourceLimb.field_78804_l).isEmpty()) {
                            stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
                            stack.func_227860_a_();
                            this.prepareArmorPositionAndScale(bone, (List<ModelRenderer.ModelBox>)cubeList2, sourceLimb, stack, false, boneSlot == EquipmentSlotType.CHEST);
                            geoArmorRenderer.setCurrentItem(this.currentEntity, armorForBone, boneSlot);
                            geoArmorRenderer.applySlot(boneSlot);
                            this.handleGeoArmorBoneVisibility((GeoArmorRenderer<GeoArmorItem>)geoArmorRenderer, sourceLimb, armorModel, boneSlot);
                            IVertexBuilder ivb = ItemRenderer.func_239386_a_((IRenderTypeBuffer)this.rtb, (RenderType)RenderType.func_239263_a_((ResourceLocation)GeoArmorRenderer.getRenderer(armorItem.getClass(), (Entity)this.currentEntity).getTextureLocation(armorItem)), (boolean)false, (boolean)armorForBone.func_77962_s());
                            geoArmorRenderer.render(this.currentPartialTicks, stack, ivb, packedLightIn);
                            stack.func_227865_b_();
                        }
                    } else if (sourceLimb != null && !(cubeList = sourceLimb.field_78804_l).isEmpty()) {
                        this.prepareArmorPositionAndScale(bone, (List<ModelRenderer.ModelBox>)cubeList, sourceLimb, stack);
                        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
                        stack.func_227860_a_();
                        ResourceLocation armorResource = this.getArmorResource((Entity)this.currentEntity, armorForBone, boneSlot, null);
                        this.renderArmorOfItem(armorItem, armorForBone, boneSlot, armorResource, sourceLimb, stack, packedLightIn, packedOverlayIn);
                        stack.func_227865_b_();
                    }
                    bufferIn = this.rtb.getBuffer(RenderType.func_228644_e_((ResourceLocation)currentTexture));
                }
            } else if (armorForBone.func_77973_b() instanceof BlockItem && ((BlockItem)armorForBone.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock) {
                this.HEAD_QUEUE.add((Tuple<GeoBone, ItemStack>)new Tuple((Object)bone, (Object)armorForBone));
            }
        }
    }

    protected void handleGeoArmorBoneVisibility(GeoArmorRenderer<? extends GeoArmorItem> geoArmorRenderer, ModelRenderer sourceLimb, BipedModel<?> armorModel, EquipmentSlotType slot) {
        IBone gbHead = geoArmorRenderer.getAndHideBone(geoArmorRenderer.headBone);
        IBone gbBody = geoArmorRenderer.getAndHideBone(geoArmorRenderer.bodyBone);
        IBone gbArmL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftArmBone);
        IBone gbArmR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightArmBone);
        IBone gbLegL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftLegBone);
        IBone gbLegR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightLegBone);
        IBone gbBootL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftBootBone);
        IBone gbBootR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightBootBone);
        if (sourceLimb == armorModel.field_78116_c || sourceLimb == armorModel.field_178720_f) {
            gbHead.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.field_78115_e) {
            gbBody.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.field_178724_i) {
            gbArmL.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.field_178722_k) {
            if (slot == EquipmentSlotType.FEET) {
                gbBootL.setHidden(false);
            } else {
                gbLegL.setHidden(false);
            }
            return;
        }
        if (sourceLimb == armorModel.field_178723_h) {
            gbArmR.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.field_178721_j) {
            if (slot == EquipmentSlotType.FEET) {
                gbBootR.setHidden(false);
            } else {
                gbLegR.setHidden(false);
            }
            return;
        }
    }

    protected void renderArmorOfItem(ArmorItem armorItem, ItemStack armorForBone, EquipmentSlotType boneSlot, ResourceLocation armorResource, ModelRenderer sourceLimb, MatrixStack stack, int packedLightIn, int packedOverlayIn) {
        if (armorItem instanceof DyeableArmorItem) {
            int i = ((DyeableArmorItem)armorItem).func_200886_f(armorForBone);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, r, g, b, 1.0f, armorForBone, armorResource);
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, this.getArmorResource((Entity)this.currentEntity, armorForBone, boneSlot, "overlay"));
        } else {
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, armorResource);
        }
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelRenderer.ModelBox> cubeList, ModelRenderer sourceLimb, MatrixStack stack) {
        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, false, false);
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelRenderer.ModelBox> cubeList, ModelRenderer sourceLimb, MatrixStack stack, boolean geoArmor, boolean modMatrixRot) {
        GeoCube firstCube = (GeoCube)bone.childCubes.get(0);
        ModelRenderer.ModelBox armorCube = cubeList.get(0);
        float targetSizeX = firstCube.size.func_195899_a();
        float targetSizeY = firstCube.size.func_195900_b();
        float targetSizeZ = firstCube.size.func_195902_c();
        float sourceSizeX = Math.abs(armorCube.field_78248_d - armorCube.field_78252_a);
        float sourceSizeY = Math.abs(armorCube.field_78249_e - armorCube.field_78250_b);
        float sourceSizeZ = Math.abs(armorCube.field_78246_f - armorCube.field_78251_c);
        float scaleX = targetSizeX / sourceSizeX;
        float scaleY = targetSizeY / sourceSizeY;
        float scaleZ = targetSizeZ / sourceSizeZ;
        sourceLimb.func_78793_a(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        if (!geoArmor) {
            sourceLimb.field_78795_f = -bone.getRotationX();
            sourceLimb.field_78796_g = -bone.getRotationY();
            sourceLimb.field_78808_h = bone.getRotationZ();
        } else {
            float xRot = -bone.getRotationX();
            float yRot = -bone.getRotationY();
            float zRot = bone.getRotationZ();
            sourceLimb.field_78795_f = xRot;
            sourceLimb.field_78796_g = yRot;
            sourceLimb.field_78808_h = zRot;
        }
        stack.func_227862_a_(scaleX, scaleY, scaleZ);
    }

    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ResourceLocation tfb = this.getCurrentModelRenderCycle() != software.bernie.geckolib3.util.EModelRenderCycle.INITIAL ? null : this.getTextureForBone(bone.getName(), this.currentAnimatable);
        boolean customTextureMarker = tfb != null;
        ResourceLocation currentTexture = this.func_110775_a((Entity)this.currentEntity);
        if (customTextureMarker) {
            currentTexture = tfb;
            if (this.rtb != null) {
                RenderType rt = this.getRenderTypeForBone(bone, this.currentAnimatable, this.currentPartialTicks, stack, bufferIn, this.rtb, packedLightIn, currentTexture);
                bufferIn = this.rtb.getBuffer(rt);
            }
        }
        if (this.getCurrentModelRenderCycle() == software.bernie.geckolib3.util.EModelRenderCycle.INITIAL) {
            stack.func_227860_a_();
            if (this.isArmorBone(bone)) {
                stack.func_227860_a_();
                try {
                    this.handleArmorRenderingForBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, currentTexture);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                stack.func_227865_b_();
            } else {
                ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentAnimatable);
                BlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentAnimatable);
                if (boneItem != null || boneBlock != null) {
                    stack.func_227860_a_();
                    this.handleItemAndBlockBoneRendering(stack, bone, boneItem, boneBlock, packedLightIn, packedOverlayIn);
                    stack.func_227865_b_();
                    bufferIn = this.rtb.getBuffer(RenderType.func_228644_e_((ResourceLocation)currentTexture));
                }
            }
            stack.func_227865_b_();
        }
        this.customBoneSpecificRenderingHook(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, customTextureMarker, currentTexture);
        if (customTextureMarker) {
            bufferIn = this.currentVertexBuilderInUse;
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected void customBoneSpecificRenderingHook(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean customTextureMarker, ResourceLocation currentTexture) {
    }

    protected void handleItemAndBlockBoneRendering(MatrixStack stack, GeoBone bone, @Nullable ItemStack boneItem, @Nullable BlockState boneBlock, int packedLightIn, int packedOverlayIn) {
        RenderUtils.translate((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.moveToPivot((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.rotate((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.scale((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.moveBackFromPivot((GeoBone)bone, (MatrixStack)stack);
        this.moveAndRotateMatrixToMatchBone(stack, bone);
        if (boneItem != null) {
            this.preRenderItem(stack, boneItem, bone.getName(), this.currentAnimatable, (IBone)bone);
            this.renderItemStack(stack, this.rtb, packedLightIn, boneItem, bone.getName());
            this.postRenderItem(stack, boneItem, bone.getName(), this.currentAnimatable, (IBone)bone);
        }
        if (boneBlock != null) {
            this.preRenderBlock(stack, boneBlock, bone.getName(), this.currentAnimatable);
            this.renderBlock(stack, this.rtb, packedLightIn, boneBlock);
            this.postRenderBlock(stack, boneBlock, bone.getName(), this.currentAnimatable);
        }
    }

    protected void renderItemStack(MatrixStack stack, IRenderTypeBuffer rtb, int packedLightIn, ItemStack boneItem, String boneName) {
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(this.currentEntity, boneItem, this.getCameraTransformForItemAtBone(boneItem, boneName), false, stack, rtb, packedLightIn);
    }

    protected RenderType getRenderTypeForBone(GeoBone bone, T currentEntityBeingRendered2, float currentPartialTicks2, MatrixStack stack, IVertexBuilder bufferIn, IRenderTypeBuffer currentRenderTypeBufferInUse2, int packedLightIn, ResourceLocation currentTexture) {
        return this.getRenderType(currentEntityBeingRendered2, currentPartialTicks2, stack, currentRenderTypeBufferInUse2, bufferIn, packedLightIn, currentTexture);
    }

    protected void renderArmorPart(MatrixStack stack, ModelRenderer sourceLimb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, ItemStack armorForBone, ResourceLocation armorResource) {
        IVertexBuilder ivb = ItemRenderer.func_239386_a_((IRenderTypeBuffer)this.rtb, (RenderType)RenderType.func_239263_a_((ResourceLocation)armorResource), (boolean)false, (boolean)armorForBone.func_77962_s());
        sourceLimb.func_228309_a_(stack, ivb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);

    protected void renderBlock(MatrixStack matrixStack, IRenderTypeBuffer rtb, int packedLightIn, BlockState iBlockState) {
        if (iBlockState.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.25, -0.25, -0.25);
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(iBlockState, matrixStack, rtb, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }

    @Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    protected abstract ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack var1, String var2);

    @Nullable
    protected abstract BlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(MatrixStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void preRenderBlock(MatrixStack var1, BlockState var2, String var3, T var4);

    protected abstract void postRenderItem(MatrixStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void postRenderBlock(MatrixStack var1, BlockState var2, String var3, T var4);

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected EquipmentSlotType getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected ModelRenderer getArmorPartForBone(String name, BipedModel<?> armorModel) {
        return null;
    }

    protected ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public static enum EModelRenderCycle implements IRenderCycle
    {
        INITIAL,
        REPEATED,
        SPECIAL;

    }

    public static interface IRenderCycle {
        public String name();
    }
}

