/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.piglin;

import com.infamous.dungeons_mobs.client.renderer.layers.FungusSackLayer;
import com.infamous.dungeons_mobs.interfaces.ISmartCrossbowUser;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class CustomPiglinRenderer
extends PiglinRenderer {
    public static final Map<EntityType<?>, Map<String, ResourceLocation>> RESOURCE_LOCATION_MAP = new HashMap();

    public CustomPiglinRenderer(EntityRendererManager rendererManager, boolean isZombified, boolean isFungusThrower) {
        super(rendererManager, isZombified);
        if (isFungusThrower) {
            this.func_177094_a(new FungusSackLayer(this));
        }
    }

    protected void scale(MobEntity mobEntity, MatrixStack matrixStack, float v) {
        super.func_225620_a_((LivingEntity)mobEntity, matrixStack, v);
    }

    public ResourceLocation func_110775_a(MobEntity mobEntity) {
        boolean isVanillaMob;
        boolean bl = isVanillaMob = mobEntity.func_200600_R() == EntityType.field_233591_ai_ || mobEntity.func_200600_R() == EntityType.field_233592_ba_;
        if (isVanillaMob && mobEntity instanceof ISmartCrossbowUser && !((ISmartCrossbowUser)mobEntity).isCrossbowUser()) {
            return super.func_110775_a(mobEntity);
        }
        String skinVariantName = this.getSkinVariantName(mobEntity);
        return RESOURCE_LOCATION_MAP.computeIfAbsent(mobEntity.func_200600_R(), type -> new HashMap()).computeIfAbsent(skinVariantName, s -> new ResourceLocation("dungeons_mobs", this.getPath(skinVariantName)));
    }

    private String getPath(String skinVariantName) {
        return "textures/entity/piglin/" + skinVariantName + ".png";
    }

    private String getSkinVariantName(MobEntity mobEntity) {
        String skinVariantName = mobEntity.func_200600_R().getRegistryName().func_110623_a();
        skinVariantName = this.maybeAddArmorPrefix(mobEntity, skinVariantName);
        skinVariantName = this.maybeAddHunterSuffix(mobEntity, skinVariantName);
        return skinVariantName;
    }

    private String maybeAddArmorPrefix(MobEntity mobEntity, String in) {
        Item helmetItem = mobEntity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b();
        if (helmetItem.equals(ModItems.GOLD_PIGLIN_HELMET.get()) || helmetItem.equals(ModItems.CRACKED_GOLD_PIGLIN_HELMET.get())) {
            return "gold_armored_" + in;
        }
        if (helmetItem.equals(ModItems.NETHERITE_PIGLIN_HELMET.get()) || helmetItem.equals(ModItems.CRACKED_NETHERITE_PIGLIN_HELMET.get())) {
            return "netherite_armored_" + in;
        }
        return in;
    }

    private String maybeAddHunterSuffix(MobEntity mobEntity, String in) {
        if (mobEntity instanceof ISmartCrossbowUser && ((ISmartCrossbowUser)mobEntity).isCrossbowUser()) {
            return in + "_hunter";
        }
        return in;
    }
}

