/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

@OnlyIn(value=Dist.CLIENT)
public class PulsatingGlowLayer<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    public ResourceLocation textureLocation;
    public float pulseSpeed;
    public float pulseAmount;
    public float minimumPulseAmount;

    public PulsatingGlowLayer(IGeoRenderer<T> endermanReplacementRenderer, ResourceLocation textureLocation, float pulseSpeed, float pulseAmount, float minimumPulseAmount) {
        super(endermanReplacementRenderer);
        this.textureLocation = textureLocation;
        this.pulseSpeed = pulseSpeed;
        this.pulseAmount = pulseAmount;
        this.minimumPulseAmount = minimumPulseAmount;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        GeoModelProvider geomodel = this.getEntityModel();
        float glow = Math.max(this.minimumPulseAmount, MathHelper.func_76134_b((float)(ageInTicks * this.pulseSpeed)) * this.pulseAmount);
        this.renderModel(geomodel, this.textureLocation, matrixStackIn, bufferIn, packedLightIn, (Entity)entitylivingbaseIn, 1.0f, glow, glow, glow);
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.func_228652_i_((ResourceLocation)textureLocation);
    }
}

