/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.IEnchantable;
import com.infamous.dungeons_mobs.capabilities.ancient.AncientHelper;
import com.infamous.dungeons_mobs.capabilities.ancient.IAncient;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MobEnchantmentGlintLayer<T extends Entity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation NORMAL_LOCATION = new ResourceLocation("dungeons_mobs", "textures/misc/mob_enchantment_glint.png");
    private static final ResourceLocation ANCIENT_LOCATION = new ResourceLocation("dungeons_mobs", "textures/misc/ancient_glint.png");

    public MobEnchantmentGlintLayer(IEntityRenderer<T, M> p_i226038_1_) {
        super(p_i226038_1_);
    }

    public void func_225628_a_(MatrixStack p_225628_1_, IRenderTypeBuffer p_225628_2_, int p_225628_3_, T entity, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        IEnchantable cap = EnchantableHelper.getEnchantableCapability(entity);
        if (cap.hasEnchantment()) {
            float f = (float)((Entity)entity).field_70173_aa + p_225628_7_;
            EntityModel entitymodel = this.func_215332_c();
            entitymodel.func_212843_a_(entity, p_225628_5_, p_225628_6_, p_225628_7_);
            this.func_215332_c().func_217111_a(entitymodel);
            IVertexBuilder ivertexbuilder = p_225628_2_.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.getTextureLocationForEnchantment(entity), (float)this.xOffset(f), (float)(f * 0.01f)));
            entitymodel.func_225597_a_(entity, p_225628_5_, p_225628_6_, p_225628_8_, p_225628_9_, p_225628_10_);
            float intensity = cap.getEnchantments().size() < 3 ? (float)cap.getEnchantments().size() / 3.0f : 3.0f;
            entitymodel.func_225598_a_(p_225628_1_, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, intensity, intensity, intensity, intensity);
        }
    }

    protected float xOffset(float p_225634_1_) {
        return p_225634_1_ * 0.01f;
    }

    protected ResourceLocation getTextureLocationForEnchantment(T entity) {
        IAncient cap = AncientHelper.getAncientCapability(entity);
        if (cap.isAncient()) {
            return ANCIENT_LOCATION;
        }
        return NORMAL_LOCATION;
    }
}

