/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IllagerBipedArmorLayer<T extends AbstractIllagerEntity, M extends IllagerBipedModel<T>, A extends BipedModel<T>>
extends BipedArmorLayer<T, M, A> {
    private final A armorModel;
    private final IllagerBipedModel<T> crossedArmsArmorModel;

    public IllagerBipedArmorLayer(IEntityRenderer<T, M> p_i50936_1_, A p_i50936_2_, A p_i50936_3_, IllagerBipedModel<T> crossedArmsArmorModel) {
        super(p_i50936_1_, p_i50936_2_, p_i50936_3_);
        this.armorModel = p_i50936_3_;
        this.crossedArmsArmorModel = crossedArmsArmorModel;
    }

    public void render(MatrixStack p_225628_1_, IRenderTypeBuffer p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        super.func_225628_a_(p_225628_1_, p_225628_2_, p_225628_3_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_);
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlotType.CHEST, p_225628_3_, this.crossedArmsArmorModel);
    }

    private void renderArmorPiece(MatrixStack p_241739_1_, IRenderTypeBuffer p_241739_2_, T p_241739_3_, EquipmentSlotType p_241739_4_, int p_241739_5_, IllagerBipedModel<T> crossedArmsModel) {
        ArmorItem armoritem;
        ItemStack itemstack = p_241739_3_.func_184582_a(p_241739_4_);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == p_241739_4_) {
            ((IllagerBipedModel)this.func_215332_c()).copyPropertiesTo(crossedArmsModel);
            ResourceLocation crossedTexture = this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, "crossed");
            boolean armsCanBeCrossed = IllagerArmsUtil.resourceExists(crossedTexture);
            this.setPartVisibilityCrossedArms(crossedArmsModel, p_241739_4_, armsCanBeCrossed);
            if (!armsCanBeCrossed) {
                return;
            }
            boolean flag1 = itemstack.func_77962_s();
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, f, f1, f2, crossedTexture);
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, "crossed_overlay"));
            } else {
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, 1.0f, 1.0f, 1.0f, crossedTexture);
            }
        }
    }

    private void renderModel(MatrixStack p_241738_1_, IRenderTypeBuffer p_241738_2_, int p_241738_3_, boolean p_241738_5_, IllagerBipedModel<T> p_241738_6_, float p_241738_8_, float p_241738_9_, float p_241738_10_, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)p_241738_2_, (RenderType)RenderType.func_239263_a_((ResourceLocation)armorResource), (boolean)false, (boolean)p_241738_5_);
        p_241738_6_.func_225598_a_(p_241738_1_, ivertexbuilder, p_241738_3_, OverlayTexture.field_229196_a_, p_241738_8_, p_241738_9_, p_241738_10_, 1.0f);
    }

    protected void func_188359_a(A entityModel, EquipmentSlotType p_188359_2_) {
        super.func_188359_a(entityModel, p_188359_2_);
        if (p_188359_2_ == EquipmentSlotType.CHEST) {
            ((BipedModel)entityModel).field_178723_h.field_78806_j = true;
            ((BipedModel)entityModel).field_178724_i.field_78806_j = true;
        }
    }

    private void setPartVisibilityCrossedArms(IllagerBipedModel<T> illagerEntityModel, EquipmentSlotType p_188359_2_, boolean armsCanBeCrossed) {
        illagerEntityModel.func_178719_a(false);
        illagerEntityModel.jacket.field_78806_j = false;
        illagerEntityModel.arms.field_78806_j = false;
        if (p_188359_2_ == EquipmentSlotType.CHEST) {
            illagerEntityModel.jacket.field_78806_j = true;
            if (((IllagerBipedModel)this.func_215332_c()).arms.field_78806_j && armsCanBeCrossed) {
                illagerEntityModel.arms.field_78806_j = true;
                illagerEntityModel.field_178723_h.field_78806_j = false;
                illagerEntityModel.field_178724_i.field_78806_j = false;
            } else {
                illagerEntityModel.arms.field_78806_j = false;
                illagerEntityModel.field_178723_h.field_78806_j = false;
                illagerEntityModel.field_178724_i.field_78806_j = false;
            }
        }
    }
}

