/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.IEnchantable;
import com.infamous.dungeons_mobs.capabilities.ancient.AncientHelper;
import com.infamous.dungeons_mobs.capabilities.ancient.IAncient;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

@OnlyIn(value=Dist.CLIENT)
public class GeoMobEnchantmentGlintLayer<T extends Entity>
extends GeoLayerRenderer<T> {
    private static final ResourceLocation NORMAL_LOCATION = new ResourceLocation("dungeons_mobs", "textures/misc/mob_enchantment_glint.png");
    private static final ResourceLocation ANCIENT_LOCATION = new ResourceLocation("dungeons_mobs", "textures/misc/ancient_glint.png");
    private GeoModelProvider<T> modelProvider;

    public GeoMobEnchantmentGlintLayer(IGeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IEnchantable cap = EnchantableHelper.getEnchantableCapability(entity);
        if (cap.hasEnchantment()) {
            float f = (float)((Entity)entity).field_70173_aa + partialTicks;
            float intensity = cap.getEnchantments().size() < 3 ? (float)cap.getEnchantments().size() / 3.0f : 3.0f;
            RenderType glint = RenderType.func_228636_a_((ResourceLocation)this.getTextureLocationForEnchantment(entity), (float)this.xOffset(f), (float)(f * 0.01f));
            this.getRenderer().render(this.getEntityModel().getModel(this.getEntityModel().getModelLocation(entity)), entity, partialTicks, glint, matrixStack, bufferIn, bufferIn.getBuffer(glint), packedLightIn, OverlayTexture.field_229196_a_, intensity, intensity, intensity, intensity);
        }
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.func_228655_k_();
    }

    protected float xOffset(float p_225634_1_) {
        return p_225634_1_ * 0.01f;
    }

    protected ResourceLocation getTextureLocationForEnchantment(T entity) {
        IAncient cap = AncientHelper.getAncientCapability(entity);
        if (cap.isAncient()) {
            return ANCIENT_LOCATION;
        }
        return NORMAL_LOCATION;
    }

    protected ResourceLocation getModel(T entity) {
        ResourceLocation registryName = entity.func_200600_R().getRegistryName();
        return new ResourceLocation(registryName.func_110624_b(), "geo/" + registryName.func_110623_a() + ".geo.json");
    }
}

