/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.illager.ReplacedVindicatorModel;
import com.infamous.dungeons_mobs.client.renderer.util.ModExtentedGeoReplacedEntityRenderer;
import com.infamous.dungeons_mobs.entities.illagers.ReplacedVindicatorEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;

public class ReplacedVindicatorRenderer
extends ModExtentedGeoReplacedEntityRenderer<ReplacedVindicatorEntity> {
    public ReplacedVindicatorRenderer(EntityRendererManager renderManager) {
        super(renderManager, new ReplacedVindicatorModel(), new ReplacedVindicatorEntity());
    }

    @Override
    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Override
    @Nullable
    protected ResourceLocation getTextureForBone(String s, ReplacedVindicatorEntity currentEntity) {
        return null;
    }

    @Override
    protected ItemStack getHeldItemForBone(String boneName, ReplacedVindicatorEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.getMobEntity().func_184638_cS() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.getMobEntity().func_184638_cS() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    @Override
    protected ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemCameraTransforms.TransformType.NONE;
    }

    @Override
    protected void preRenderItem(MatrixStack stack, ItemStack item, String boneName, ReplacedVindicatorEntity currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            stack.func_227862_a_(1.1f, 1.1f, 1.1f);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            boolean shieldFlag = item.func_77973_b() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    stack.func_227861_a_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.func_227861_a_(-0.15, 0.125, 0.05);
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
    }

    @Override
    protected void postRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, ReplacedVindicatorEntity currentEntity, IBone bone) {
    }

    @Override
    protected BlockState getHeldBlockForBone(String boneName, ReplacedVindicatorEntity currentEntity) {
        return null;
    }

    @Override
    protected void preRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, ReplacedVindicatorEntity currentEntity) {
    }

    @Override
    protected void postRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, ReplacedVindicatorEntity currentEntity) {
    }

    @Override
    @Nullable
    protected ItemStack getArmorForBone(String boneName, ReplacedVindicatorEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.boots;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggings;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return this.chestplate;
            }
            case "armorBipedHead": {
                return this.helmet;
            }
        }
        return null;
    }

    @Override
    protected EquipmentSlotType getEquipmentSlotForArmorBone(String boneName, ReplacedVindicatorEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlotType.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlotType.LEGS;
            }
            case "armorBipedRightHand": {
                return !currentEntity.getMobEntity().func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedLeftHand": {
                return currentEntity.getMobEntity().func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": 
            case "armorBipedBody": {
                return EquipmentSlotType.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlotType.HEAD;
            }
        }
        return null;
    }

    @Override
    protected ModelRenderer getArmorPartForBone(String name, BipedModel<?> armorBipedModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorBipedModel.field_178722_k;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorBipedModel.field_178721_j;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorBipedModel.field_178723_h;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorBipedModel.field_178724_i;
            }
            case "armorBipedBody": {
                return armorBipedModel.field_78115_e;
            }
            case "armorBipedHead": {
                return armorBipedModel.field_78116_c;
            }
        }
        return null;
    }

    @Override
    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelRenderer.ModelBox> cubeList, ModelRenderer sourceLimb, MatrixStack stack, boolean geoArmor, boolean modMatrixRot) {
        super.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, geoArmor, modMatrixRot);
        if (bone.getName().equals("armorBipedHead") && geoArmor && this.helmet.func_77973_b().getRegistryName().func_110624_b().equals("dungeons_mobs")) {
            stack.func_227861_a_(0.0, 0.125, 0.0);
        }
    }
}

