/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.armor.IllagerArmorModel;
import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.client.renderer.layers.IllagerBipedArmorLayer;
import com.infamous.dungeons_mobs.entities.illagers.MountaineerEntity;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public class CustomVindicatorRenderer
extends MobRenderer<VindicatorEntity, IllagerBipedModel<VindicatorEntity>> {
    private static final ResourceLocation GOLD_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/gold_armored_vindicator.png");
    private static final ResourceLocation DIAMOND_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/diamond_armored_vindicator.png");
    private static final ResourceLocation VINDICATOR_TEXTURE = new ResourceLocation("textures/entity/illager/vindicator.png");
    private static final ResourceLocation MOUNTAINEER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/mountaineer.png");
    private static final ResourceLocation VINDICATOR_CHEF_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/vindicator_chef.png");

    public CustomVindicatorRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new IllagerBipedModel(0.0f, 0.0f, 64, 64), 0.5f);
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new IllagerBipedArmorLayer(this, new IllagerArmorModel(0.5f), new IllagerArmorModel(1.0f), new IllagerBipedModel(1.0f, 0.0f, 64, 64)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer<VindicatorEntity, IllagerBipedModel<VindicatorEntity>>((IEntityRenderer)this){

            public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, VindicatorEntity vindicatorEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (vindicatorEntity.func_213398_dR() || vindicatorEntity.func_193077_p() == AbstractIllagerEntity.ArmPose.NEUTRAL) {
                    super.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (LivingEntity)vindicatorEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
    }

    protected void scale(VindicatorEntity vindicatorEntity, MatrixStack matrixStack, float v) {
        float scaleFactor = 0.9375f;
        matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        super.func_225620_a_((LivingEntity)vindicatorEntity, matrixStack, v);
    }

    public ResourceLocation getTextureLocation(VindicatorEntity entity) {
        if (entity instanceof MountaineerEntity) {
            return MOUNTAINEER_TEXTURE;
        }
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().equals(ModItems.DIAMOND_VINDICATOR_HELMET.get())) {
            return DIAMOND_ARMORED_VINDICATOR_TEXTURE;
        }
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().equals(ModItems.GOLD_VINDICATOR_HELMET.get())) {
            return GOLD_ARMORED_VINDICATOR_TEXTURE;
        }
        return VINDICATOR_TEXTURE;
    }
}

