/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.armor.IllagerArmorModel;
import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public class CustomPillagerRenderer
extends MobRenderer<PillagerEntity, IllagerBipedModel<PillagerEntity>> {
    private static final ResourceLocation GOLD_ARMORED_PILLAGER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/gold_armored_pillager.png");
    private static final ResourceLocation DIAMOND_ARMORED_PILLAGER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/diamond_armored_pillager.png");
    private static final ResourceLocation PILLAGER_TEXTURE = new ResourceLocation("textures/entity/illager/pillager.png");

    public CustomPillagerRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new IllagerBipedModel(0.0f, 0.0f, 64, 64), 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new IllagerArmorModel(0.5f), new IllagerArmorModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
    }

    protected void scale(PillagerEntity pillagerEntity, MatrixStack matrixStack, float v) {
        float scaleFactor = 0.9375f;
        matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        super.func_225620_a_((LivingEntity)pillagerEntity, matrixStack, v);
    }

    public ResourceLocation getTextureLocation(PillagerEntity entity) {
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().equals(ModItems.DIAMOND_PILLAGER_HELMET.get())) {
            return DIAMOND_ARMORED_PILLAGER_TEXTURE;
        }
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().equals(ModItems.GOLD_PILLAGER_HELMET.get())) {
            return GOLD_ARMORED_PILLAGER_TEXTURE;
        }
        return PILLAGER_TEXTURE;
    }
}

