/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.blaze;

import com.infamous.dungeons_mobs.client.models.blaze.WildfireModel;
import com.infamous.dungeons_mobs.client.renderer.layers.PulsatingGlowLayer;
import com.infamous.dungeons_mobs.entities.blaze.WildfireEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class WildfireRenderer
extends ExtendedGeoEntityRenderer<WildfireEntity> {
    public WildfireRenderer(EntityRendererManager renderManager) {
        super(renderManager, (AnimatedGeoModel)new WildfireModel());
        this.addLayer(new PulsatingGlowLayer(this, new ResourceLocation("dungeons_mobs", "textures/entity/blaze/wildfire.png"), 0.1f, 1.0f, 0.25f));
    }

    protected int getBlockLightLevel(WildfireEntity p_225624_1_, BlockPos p_225624_2_) {
        return 15;
    }

    protected void applyRotations(WildfireEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float scaleFactor = 1.25f;
        matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public RenderType getRenderType(WildfireEntity animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String s, WildfireEntity windcallerEntity) {
        return null;
    }

    protected ItemStack getHeldItemForBone(String boneName, WildfireEntity currentEntity) {
        return null;
    }

    protected ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        return ItemCameraTransforms.TransformType.NONE;
    }

    protected void preRenderItem(MatrixStack stack, ItemStack item, String boneName, WildfireEntity currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            stack.func_227862_a_(1.1f, 1.1f, 1.1f);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            boolean shieldFlag = item.func_77973_b() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    stack.func_227861_a_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.func_227861_a_(-0.15, 0.125, 0.05);
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
    }

    protected void postRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, WildfireEntity currentEntity, IBone bone) {
    }

    protected BlockState getHeldBlockForBone(String boneName, WildfireEntity currentEntity) {
        return null;
    }

    protected void preRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, WildfireEntity currentEntity) {
    }

    protected void postRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, WildfireEntity currentEntity) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, WildfireEntity currentEntity) {
        switch (boneName) {
            case "armorHead": {
                return this.helmet;
            }
        }
        return null;
    }

    protected EquipmentSlotType getEquipmentSlotForArmorBone(String boneName, WildfireEntity currentEntity) {
        switch (boneName) {
            case "armorHead": {
                return EquipmentSlotType.HEAD;
            }
        }
        return null;
    }

    protected ModelRenderer getArmorPartForBone(String name, BipedModel<?> armorBipedModel) {
        switch (name) {
            case "armorHead": {
                return armorBipedModel.field_78116_c;
            }
        }
        return null;
    }
}

