/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.undead;

import com.infamous.dungeons_mobs.entities.undead.WraithEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WraithModel
extends AnimatedGeoModel<WraithEntity> {
    public ResourceLocation getAnimationFileLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/wraith.animation.json");
    }

    public ResourceLocation getModelLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/wraith.geo.json");
    }

    public ResourceLocation getTextureLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/wraith/wraith.png");
    }

    public void setLivingAnimations(WraithEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        cape.setHidden(true);
        IBone leftHand = this.getAnimationProcessor().getBone("bipedHandLeft");
        IBone rightHand = this.getAnimationProcessor().getBone("bipedHandRight");
        if (entity.field_70173_aa % 2 == 0 && rightHand instanceof GeoBone && leftHand instanceof GeoBone && entity.isSpellcasting()) {
            GeoBone leftHandBone = (GeoBone)leftHand;
            GeoBone rightHandBone = (GeoBone)rightHand;
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, leftHandBone.getWorldPosition().field_72450_a, leftHandBone.getWorldPosition().field_72448_b, leftHandBone.getWorldPosition().field_72449_c, entity.func_70681_au().nextGaussian() * 0.01, entity.func_70681_au().nextGaussian() * 0.01, entity.func_70681_au().nextGaussian() * 0.01);
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, rightHandBone.getWorldPosition().field_72450_a, rightHandBone.getWorldPosition().field_72448_b, rightHandBone.getWorldPosition().field_72449_c, entity.func_70681_au().nextGaussian() * 0.01, entity.func_70681_au().nextGaussian() * 0.01, entity.func_70681_au().nextGaussian() * 0.01);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

