/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.ocean;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.water.DrownedNecromancerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

@OnlyIn(value=Dist.CLIENT)
public class DrownedNecromancerModel
extends AnimatedGeoModel<DrownedNecromancerEntity> {
    public ResourceLocation getAnimationFileLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/drowned_necromancer.animation.json");
    }

    public ResourceLocation getModelLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/drowned_necromancer.geo.json");
    }

    public ResourceLocation getTextureLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/ocean/drowned_necromancer.png");
    }

    public void setLivingAnimations(DrownedNecromancerEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        IBone particles = this.getAnimationProcessor().getBone("staffParticles");
        if (particles instanceof GeoBone && entity.isSpellcasting()) {
            GeoBone particleBone = (GeoBone)particles;
            entity.field_70170_p.func_195594_a((IParticleData)(entity.func_203005_aq() ? ParticleTypes.field_203220_f : (IParticleData)ModParticleTypes.NECROMANCY.get()), particleBone.getWorldPosition().field_72450_a, particleBone.getWorldPosition().field_72448_b, particleBone.getWorldPosition().field_72449_c, 0.0, 0.0, 0.0);
        }
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == entity.getArmorSet().getChest().get()) {
            cape.setHidden(false);
        } else {
            cape.setHidden(true);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vector3d velocity = livingEntity.func_213322_ci();
        float groundSpeed = MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
        parser.setValue("query.ground_speed", (double)(groundSpeed * 20.0f));
    }
}

