/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.illager;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.illagers.WindcallerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WindcallerModel
extends AnimatedGeoModel<WindcallerEntity> {
    public ResourceLocation getAnimationFileLocation(WindcallerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/windcaller.animation.json");
    }

    public ResourceLocation getModelLocation(WindcallerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/windcaller.geo.json");
    }

    public ResourceLocation getTextureLocation(WindcallerEntity entity) {
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_3D_SLEEVES.get()).booleanValue()) {
            return new ResourceLocation("dungeons_mobs", "textures/entity/illager/windcaller.png");
        }
        return new ResourceLocation("dungeons_mobs", "textures/entity/illager/windcaller_sleeved.png");
    }

    public void setLivingAnimations(WindcallerEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        WindcallerEntity entityIn = entity;
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == entity.getArmorSet().getChest().get()) {
            cape.setHidden(false);
        } else {
            cape.setHidden(true);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

