/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.illager;

import com.infamous.dungeons_mobs.entities.illagers.ReplacedVindicatorEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class ReplacedVindicatorModel
extends AnimatedGeoModel {
    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("dungeons_mobs", "animations/vindicator.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        return new ResourceLocation("dungeons_mobs", "geo/geo_illager.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/illager/vindicator.png");
    }

    public void setLivingAnimations(Object entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)((ReplacedVindicatorEntity)entity), uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone illagerArms = this.getAnimationProcessor().getBone("illagerArms");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        cape.setHidden(true);
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        MobEntity livingEntity = ((ReplacedVindicatorEntity)animatable).getMobEntity();
        Vector3d velocity = livingEntity.func_213322_ci();
        float groundSpeed = MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
        parser.setValue("query.ground_speed", (double)(groundSpeed * 20.0f));
    }
}

