/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.armor;

import com.infamous.dungeons_libraries.client.model.ArmorGearModel;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.illagers.DungeonsIllusionerEntity;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class IllusionerArmorGearModel<T extends ArmorGear>
extends ArmorGearModel<T> {
    LivingEntity wearer;

    public LivingEntity getWearer() {
        return this.wearer;
    }

    public void setWearer(LivingEntity wearer) {
        this.wearer = wearer;
    }

    public void setLivingAnimations(T entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone cloak = this.getAnimationProcessor().getBone("armorCloak");
        IBone rightArm = this.getAnimationProcessor().getBone("armorRightArm");
        IBone leftArm = this.getAnimationProcessor().getBone("armorLeftArm");
        if (this.getWearer() != null && (this.getWearer() instanceof DungeonsIllusionerEntity || this.getWearer() instanceof IllusionerCloneEntity) && !((Boolean)DungeonsMobsConfig.COMMON.ENABLE_3D_SLEEVES.get()).booleanValue()) {
            rightArm.setHidden(true);
            leftArm.setHidden(true);
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        Vector3d velocity = this.wearer.func_213322_ci();
        float groundSpeed = MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
        parser.setValue("query.ground_speed", () -> groundSpeed * 13.0f);
    }
}

