/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.ancient;

import com.infamous.dungeons_mobs.capabilities.ancient.AncientHelper;
import com.infamous.dungeons_mobs.capabilities.ancient.IAncient;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import com.infamous.dungeons_mobs.network.message.AncientMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class AncientEvents {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        IAncient cap;
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (player instanceof ServerPlayerEntity && (cap = AncientHelper.getAncientCapability(target)).isAncient()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new AncientMessage(target.func_145782_y(), cap.isAncient()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        IAncient cap;
        LivingEntity entityLiving = event.getEntityLiving();
        if (!entityLiving.field_70170_p.field_72995_K && (cap = AncientHelper.getAncientCapability((Entity)entityLiving)).isAncient() && cap.getBossInfo() != null) {
            List nearbyEntities = entityLiving.field_70170_p.func_217374_a(ServerPlayerEntity.class, new EntityPredicate().func_221013_a(20.0).func_221008_a().func_221009_d().func_221010_e(), entityLiving, entityLiving.func_174813_aQ().func_72314_b(20.0, 10.0, 20.0));
            nearbyEntities.forEach(playerEntity -> cap.getBossInfo().func_186760_a(playerEntity));
            ArrayList<ServerPlayerEntity> trackingPlayers = new ArrayList<ServerPlayerEntity>(cap.getBossInfo().func_186757_c());
            List furtherEntities = entityLiving.field_70170_p.func_217374_a(ServerPlayerEntity.class, new EntityPredicate().func_221013_a(50.0).func_221008_a().func_221009_d().func_221010_e(), entityLiving, entityLiving.func_174813_aQ().func_72314_b(50.0, 20.0, 50.0));
            trackingPlayers.forEach(playerEntity -> {
                if (!furtherEntities.contains(playerEntity)) {
                    cap.getBossInfo().func_186761_b(playerEntity);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        IAncient cap = AncientHelper.getAncientCapability((Entity)livingEntity);
        if (cap.isAncient() && cap.getBossInfo() != null) {
            cap.getBossInfo().func_186735_a(livingEntity.func_110143_aJ() / livingEntity.func_110138_aP());
        }
    }
}

