/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs;

import com.infamous.dungeons_mobs.capabilities.ancient.AncientProvider;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsProvider;
import com.infamous.dungeons_mobs.capabilities.cloneable.CloneableProvider;
import com.infamous.dungeons_mobs.capabilities.convertible.ConvertibleHelper;
import com.infamous.dungeons_mobs.capabilities.convertible.ConvertibleProvider;
import com.infamous.dungeons_mobs.capabilities.convertible.IConvertible;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsProvider;
import com.infamous.dungeons_mobs.capabilities.teamable.TeamableHelper;
import com.infamous.dungeons_mobs.capabilities.teamable.TeamableProvider;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.creepers.IcyCreeperEntity;
import com.infamous.dungeons_mobs.entities.illagers.DungeonsIllusionerEntity;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.entities.undead.FrozenZombieEntity;
import com.infamous.dungeons_mobs.goals.SmartTridentAttackGoal;
import com.infamous.dungeons_mobs.interfaces.IHasItemStackData;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.mixin.TridentEntityAccessor;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class MobEvents {
    private static ArmorStandEntity DUMMY_TARGET;
    public static Random random;

    @SubscribeEvent
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity attacker = event.getEntityLiving();
        World level = attacker.field_70170_p;
        LivingEntity target = event.getTarget();
        if (attacker instanceof MobEntity && target instanceof MobEntity && TeamableHelper.areTeammates((MobEntity)attacker, (MobEntity)target)) {
            MobEvents.createDummyTarget(level);
            if (attacker instanceof IAngerable) {
                ((IAngerable)attacker).func_230259_a_((UUID)null);
                ((IAngerable)attacker).func_230260_a__(0);
            }
            ((MobEntity)attacker).func_70624_b((LivingEntity)DUMMY_TARGET);
            attacker.func_70604_c((LivingEntity)DUMMY_TARGET);
        }
    }

    private static void createDummyTarget(World level) {
        if (DUMMY_TARGET == null && (DUMMY_TARGET = (ArmorStandEntity)EntityType.field_200789_c.func_200721_a(level)) != null) {
            DUMMY_TARGET.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (MobEvents.isCloneableEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "cloneable"), (ICapabilityProvider)new CloneableProvider());
        }
        if (event.getObject() instanceof MobEntity && ConvertibleHelper.convertsInWater((MobEntity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "convertible"), (ICapabilityProvider)new ConvertibleProvider());
        }
        if (event.getObject() instanceof MobEntity) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "teammable"), (ICapabilityProvider)new TeamableProvider());
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "dungeons_mobs_mob_props"), (ICapabilityProvider)new MobPropsProvider());
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "ancient"), (ICapabilityProvider)new AncientProvider());
        }
        if (event.getObject() instanceof VindicatorEntity) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "animated_props"), (ICapabilityProvider)new AnimatedPropsProvider());
        }
    }

    private static boolean isCloneableEntity(Entity object) {
        return object instanceof DungeonsIllusionerEntity;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof DrownedEntity) {
            DrownedEntity drownedEntity = (DrownedEntity)event.getEntity();
            ((GoalSelectorAccessor)drownedEntity.field_70714_bg).getAvailableGoals().removeIf(pg -> pg.func_220770_h() == 2 && pg.func_220772_j() instanceof RangedAttackGoal);
            drownedEntity.field_70714_bg.func_75776_a(2, (Goal)new SmartTridentAttackGoal((IRangedAttackMob)drownedEntity, 1.0, 40, 10.0f));
        }
        if (event.getEntity() instanceof TridentEntity) {
            ((IHasItemStackData)event.getEntity()).setDataItem(((TridentEntityAccessor)event.getEntity()).getTridentItem());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof MobEntity && ConvertibleHelper.convertsInWater((MobEntity)livingEntity)) {
            MobEntity mob = (MobEntity)livingEntity;
            if (!mob.field_70170_p.field_72995_K && mob.func_70089_S() && !mob.func_175446_cd()) {
                IConvertible convertibleCap = ConvertibleHelper.getConvertibleCapability((Entity)mob);
                if (convertibleCap == null) {
                    return;
                }
                convertibleCap.setCanConvert(mob.func_208600_a((ITag)FluidTags.field_206959_a));
                if (convertibleCap.isConverting()) {
                    convertibleCap.tickConversionTime();
                    EntityType<? extends MobEntity> convertToType = ConvertibleHelper.getDrowningConvertTo(mob);
                    if (convertibleCap.getConversionTime() < 0) {
                        if (ForgeEventFactory.canLivingConvert((LivingEntity)mob, convertToType, convertibleCap::setConversionTime)) {
                            convertibleCap.doConversion(mob, convertToType, ConvertibleHelper::onDrownedAndConvertedTo);
                        }
                    }
                } else if (convertibleCap.canConvert()) {
                    convertibleCap.tickPrepareConversionTime();
                    if (convertibleCap.getPrepareConversionTime() >= 600) {
                        convertibleCap.startConversion(300);
                    }
                } else {
                    convertibleCap.setPrepareConversionTime(-1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSnowballHitPlayer(ProjectileImpactEvent event) {
        SnowballEntity snowballEntity;
        Entity shooter;
        if (event.getEntity() instanceof SnowballEntity && (shooter = (snowballEntity = (SnowballEntity)event.getEntity()).func_234616_v_()) instanceof FrozenZombieEntity) {
            EntityRayTraceResult entityRayTraceResult;
            snowballEntity.func_184185_a((SoundEvent)ModSoundEvents.FROZEN_ZOMBIE_SNOWBALL_LAND.get(), 1.0f, 1.0f);
            RayTraceResult rayTraceResult = event.getRayTraceResult();
            if (rayTraceResult instanceof EntityRayTraceResult && (entityRayTraceResult = (EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)entityRayTraceResult.func_216348_a();
                playerEntity.func_70097_a(DamageSource.func_76356_a((Entity)snowballEntity, (Entity)shooter), 2.0f);
                int i = 0;
                if (event.getEntity().field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 3;
                } else if (event.getEntity().field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 6;
                }
                if (i > 0) {
                    playerEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSnowballDamageMob(LivingHurtEvent event) {
        if (event.getSource().func_76364_f() instanceof SnowballEntity && event.getSource().func_76346_g() instanceof FrozenZombieEntity && !(event.getEntityLiving() instanceof PlayerEntity)) {
            event.setAmount(event.getAmount() + 2.0f);
            int i = 0;
            if (event.getEntityLiving().field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                i = 3;
            } else if (event.getEntityLiving().field_70170_p.func_175659_aa() == Difficulty.HARD) {
                i = 6;
            }
            if (i > 0) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 1));
            }
        }
    }

    @SubscribeEvent
    public static void onIllusionerCloneArrowHit(ProjectileImpactEvent event) {
        AbstractArrowEntity arrowEntity;
        Entity shooter;
        if (event.getEntity() instanceof AbstractArrowEntity && (shooter = (arrowEntity = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) instanceof IllusionerCloneEntity) {
            arrowEntity.func_184185_a((SoundEvent)ModSoundEvents.ILLUSIONER_CLONE_ARROW_HIT.get(), 1.0f, 1.0f);
            if (!arrowEntity.field_70170_p.field_72995_K) {
                arrowEntity.func_70106_y();
            } else {
                for (int i = 0; i < 2; ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    arrowEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, arrowEntity.func_226282_d_(1.0), arrowEntity.func_226279_cv_(), arrowEntity.func_226287_g_(1.0), d0, d1, d2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onIceCreeperExplosion(EntityMobGriefingEvent event) {
        if (event.getEntity() instanceof IcyCreeperEntity) {
            IcyCreeperEntity iceCreeperEntity = (IcyCreeperEntity)event.getEntity();
            iceCreeperEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        MobEvents.handlePillarProtection(event);
        if (event.getExplosion().func_94613_c() instanceof IcyCreeperEntity) {
            if (!((Boolean)DungeonsMobsConfig.COMMON.ENABLE_ICY_CREEPER_GRIEFING.get()).booleanValue()) {
                event.getAffectedBlocks().clear();
            }
            List entityList = event.getAffectedEntities();
            for (Entity entity : entityList) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
            }
        }
    }

    private static void handlePillarProtection(ExplosionEvent.Detonate event) {
        boolean pillarsArePresent;
        Explosion explosion = event.getExplosion();
        Entity source = explosion.getExploder();
        BlockPos detonationOrigin = new BlockPos(explosion.getPosition());
        List entityList = event.getAffectedEntities();
        ArrayList<ConstructEntity> potentialProtectingPillars = new ArrayList<ConstructEntity>(Collections.emptyList());
        for (Entity entity : entityList) {
            if (!(entity instanceof ConstructEntity) || entity == source) continue;
            potentialProtectingPillars.add((ConstructEntity)entity);
        }
        boolean bl = pillarsArePresent = !potentialProtectingPillars.isEmpty();
        if (!pillarsArePresent) {
            return;
        }
        Iterator it = entityList.iterator();
        while (it.hasNext()) {
            boolean protectedByPillar;
            Entity currentEntity = (Entity)it.next();
            boolean notAPillar = !(currentEntity instanceof ConstructEntity);
            if (!notAPillar || currentEntity == null || !(protectedByPillar = MobEvents.entityProtectedByPillar(currentEntity, potentialProtectingPillars, detonationOrigin))) continue;
            it.remove();
        }
    }

    private static boolean entityProtectedByPillar(Entity entity, List<ConstructEntity> pillarEntities, BlockPos detonationOrigin) {
        if (pillarEntities.isEmpty()) {
            return false;
        }
        BlockPos entityPos = entity.func_233580_cy_();
        for (ConstructEntity pillarEntity : pillarEntities) {
            double distanceExplosionToEntity;
            double distanceExplosionToPillar;
            BlockPos pillarPos = pillarEntity.func_233580_cy_();
            double widthAllowance = pillarEntity.func_213311_cf();
            double distanceEntityToPillar = Math.sqrt(entityPos.func_177951_i((Vector3i)pillarPos));
            boolean canProtect = distanceEntityToPillar + (distanceExplosionToPillar = Math.sqrt(detonationOrigin.func_177951_i((Vector3i)pillarPos))) <= (distanceExplosionToEntity = Math.sqrt(detonationOrigin.func_177951_i((Vector3i)entityPos))) + widthAllowance;
            if (!canProtect) continue;
            return true;
        }
        return false;
    }

    static {
        random = new Random();
    }
}

