/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs;

import com.infamous.dungeons_libraries.client.ClientProxy;
import com.infamous.dungeons_libraries.network.CommonProxy;
import com.infamous.dungeons_mobs.capabilities.ancient.Ancient;
import com.infamous.dungeons_mobs.capabilities.ancient.AncientStorage;
import com.infamous.dungeons_mobs.capabilities.ancient.IAncient;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsStorage;
import com.infamous.dungeons_mobs.capabilities.cloneable.Cloneable;
import com.infamous.dungeons_mobs.capabilities.cloneable.CloneableStorage;
import com.infamous.dungeons_mobs.capabilities.cloneable.ICloneable;
import com.infamous.dungeons_mobs.capabilities.convertible.Convertible;
import com.infamous.dungeons_mobs.capabilities.convertible.ConvertibleStorage;
import com.infamous.dungeons_mobs.capabilities.convertible.IConvertible;
import com.infamous.dungeons_mobs.capabilities.properties.IMobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsStorage;
import com.infamous.dungeons_mobs.capabilities.teamable.ITeamable;
import com.infamous.dungeons_mobs.capabilities.teamable.Teamable;
import com.infamous.dungeons_mobs.capabilities.teamable.TeamableStorage;
import com.infamous.dungeons_mobs.client.ModItemModelProperties;
import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.compat.EnchantWithMobCompat;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.items.GroupDungeonsMobs;
import com.infamous.dungeons_mobs.items.GroupDungeonsMobsItems;
import com.infamous.dungeons_mobs.mod.ModEffects;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import com.infamous.dungeons_mobs.mod.ModRecipes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import com.infamous.dungeons_mobs.network.datasync.ModDataSerializers;
import com.infamous.dungeons_mobs.tags.CustomTags;
import com.infamous.dungeons_mobs.worldgen.BiomeSpawnEntries;
import com.infamous.dungeons_mobs.worldgen.EntitySpawnPlacements;
import com.infamous.dungeons_mobs.worldgen.RaidEntries;
import com.infamous.dungeons_mobs.worldgen.SensorMapModifier;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="dungeons_mobs")
public class DungeonsMobs {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "dungeons_mobs";
    public static final ItemGroup DUNGEONS_MOBS = new GroupDungeonsMobs("dungeonsMobs");
    public static final ItemGroup DUNGEONS_MOBS_ITEMS = new GroupDungeonsMobsItems("dungeonsMobsItems");
    public static CommonProxy PROXY;

    public DungeonsMobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DungeonsMobsConfig.COMMON_SPEC, "dungeons-mobs-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GeckoLib.initialize();
        CustomTags.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModSoundEvents.SOUNDS.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModEntityTypes.SPAWN_EGGS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModRecipes.RECIPES.register(modEventBus);
        ModParticleTypes.PARTICLES.register(modEventBus);
        if (EnchantWithMobCompat.isLoaded()) {
            ModMobEnchants.MOB_ENCHANTS_DEFERRED.register(modEventBus);
            EnchantWithMobCompat.initMobEnchants(modEventBus);
        }
        ModDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(EntitySpawnPlacements::createPlacementTypes);
        event.enqueueWork(EntitySpawnPlacements::initSpawnPlacements);
        event.enqueueWork(RaidEntries::initWaveMemberEntries);
        event.enqueueWork(SensorMapModifier::replaceSensorMaps);
        event.enqueueWork(BiomeSpawnEntries::addCustomTypesToBiomes);
        CapabilityManager.INSTANCE.register(ICloneable.class, (Capability.IStorage)new CloneableStorage(), Cloneable::new);
        CapabilityManager.INSTANCE.register(IConvertible.class, (Capability.IStorage)new ConvertibleStorage(), Convertible::new);
        CapabilityManager.INSTANCE.register(ITeamable.class, (Capability.IStorage)new TeamableStorage(), Teamable::new);
        CapabilityManager.INSTANCE.register(IMobProps.class, (Capability.IStorage)new MobPropsStorage(), MobProps::new);
        CapabilityManager.INSTANCE.register(IAncient.class, (Capability.IStorage)new AncientStorage(), Ancient::new);
        CapabilityManager.INSTANCE.register(AnimatedProps.class, (Capability.IStorage)new AnimatedPropsStorage(), AnimatedProps::new);
        event.enqueueWork(NetworkHandler::init);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ModItemModelProperties());
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_STRONGER_HUSKS.get()).booleanValue()) {
            EntityType.field_200763_C.field_220359_bi = EntitySize.func_220314_b((float)0.72f, (float)2.3400002f);
        }
    }
}

