/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.tileentity.base;

import com.mrh0.buildersaddition.util.IComparetorOverride;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class BaseChestTileEntity
extends LockableLootTileEntity
implements IComparetorOverride,
ICapabilityProvider {
    private NonNullList<ItemStack> inv = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int numPlayersUsing;
    public LazyOptional<IItemHandlerModifiable> invHandler;

    public BaseChestTileEntity(TileEntityType<?> tet) {
        super(tet);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
            this.invHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invHandler == null) {
                this.invHandler = LazyOptional.of(this::createHandler);
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ChestBlock)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        return new InvWrapper((IInventory)(inv == null ? this : inv));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.func_184282_c(nbt)) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inv);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inv = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(nbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inv);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inv;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inv = itemsIn;
    }

    protected abstract ITextComponent func_213907_g();

    protected Container func_213906_a(int id, PlayerInventory player) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)player, (IInventory)this);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            this.playSound(blockstate, SoundEvents.field_219602_O);
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void invTick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = ChestTileEntity.func_213976_a((World)this.field_145850_b, (LockableTileEntity)this, (int)i, (int)j, (int)k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.func_195044_w();
            if (!blockstate.func_177230_c().hasTileEntity(blockstate)) {
                this.func_145843_s();
                return;
            }
            this.playSound(blockstate, SoundEvents.field_219601_N);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    protected abstract void playSound(BlockState var1, SoundEvent var2);

    @Override
    public int getComparetorOverride() {
        return Container.func_94526_b((IInventory)this);
    }
}

