/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.RedUIRootNode;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.fml.client.gui.GuiUtils;

public interface RedUINode {
    public RedUIRootNode getRoot();

    public void setRoot(@Nullable RedUIRootNode var1);

    public RedUINode getParent();

    public void setParent(@Nullable RedUINode var1);

    public List<RedUINode> getOurChildren();

    public Rect getFrame();

    public Point getPosition();

    public double getZPosition();

    public void setZPosition(double var1);

    public double getRelativeZPosition();

    public boolean isHidden();

    default public boolean isRoot() {
        return this.getRoot() == this;
    }

    default public void assertValidNode() throws RuntimeException {
        if (this.getRoot() == null || this.getParent() == null) {
            throw new RuntimeException("Node is not valid");
        }
    }

    default public List<RedUINode> buildParentHierarchy(RedUINode to) {
        LinkedList<RedUINode> hierarchy = new LinkedList<RedUINode>();
        RedUINode next = this;
        hierarchy.add(next);
        while (!next.isRoot() && next != to) {
            if ((next = next.getParent()) == null) {
                throw new RuntimeException("Found node with null parent while building parent hierarchy");
            }
            hierarchy.add(next);
        }
        return hierarchy;
    }

    default public List<RedUINode> getSubTree(Predicate<RedUINode> filter, boolean leavesFirst) {
        LinkedList<RedUINode> subTree = new LinkedList<RedUINode>();
        LinkedList<RedUINode> queue = new LinkedList<RedUINode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            RedUINode next = (RedUINode)queue.poll();
            if (!filter.test(next)) continue;
            if (leavesFirst) {
                subTree.addFirst(next);
            } else {
                subTree.add(next);
            }
            queue.addAll(next.getOurChildren());
        }
        return subTree;
    }

    default public List<RedUINode> getSubTree(Predicate<RedUINode> filter) {
        return this.getSubTree(filter, false);
    }

    default public List<RedUINode> getZOrderedSubtree(Predicate<RedUINode> filter, boolean reversed) {
        List<RedUINode> subTree = this.getSubTree(filter, !reversed);
        subTree.sort(Comparator.comparingDouble(n -> n.getZPosition() * (double)(reversed ? 1 : -1)));
        return subTree;
    }

    default public List<RedUINode> getZOrderedChildren(Predicate<RedUINode> filter, boolean reversed) {
        return this.getOurChildren().stream().filter(filter).sorted(Comparator.comparingDouble(n -> n.getZPosition() * (double)(reversed ? 1 : -1))).collect(Collectors.toList());
    }

    default public boolean isDescendantOf(RedUINode node) {
        return node != this && this.buildParentHierarchy(node).contains(node);
    }

    default public boolean isRelativeOf(RedUINode node) {
        return node != this && node.getRoot() == this.getRoot();
    }

    default public Point convertPointTo(Point p, RedUINode to) {
        if (this == to) {
            return p;
        }
        if (!this.isRelativeOf(to)) {
            throw new RuntimeException("Unable to convert point between unrelated nodes");
        }
        Point thisOffset = this.getScreenOffset();
        Point thatOffset = to.getScreenOffset();
        Point difference = thatOffset.subtract(thisOffset);
        return p.add(difference);
    }

    default public Point convertPointToScreen(Point p) {
        List<RedUINode> nodesToRoot = this.buildParentHierarchy(this.getRoot());
        Point screenOffset = nodesToRoot.stream().map(RedUINode::getPosition).reduce(Point.ZERO, Point::add);
        return p.add(screenOffset);
    }

    default public Point convertPointFromScreen(Point p) {
        List<RedUINode> nodesToRoot = this.buildParentHierarchy(this.getRoot());
        Point screenOffset = nodesToRoot.stream().map(RedUINode::getPosition).reduce(Point.ZERO, Point::add);
        return p.subtract(screenOffset);
    }

    default public Point getScreenOffset() {
        return this.buildParentHierarchy(this.getRoot()).stream().map(RedUINode::getPosition).reduce(Point.ZERO, Point::add);
    }

    default public Rect convertRectTo(Rect r, RedUINode to) {
        return new Rect(this.convertPointTo(r.origin, to), r.size);
    }

    default public Rect convertRectToScreen(Rect r) {
        return new Rect(this.convertPointToScreen(r.origin), r.size);
    }

    default public Rect convertRectFromScreen(Rect r) {
        return new Rect(this.convertPointFromScreen(r.origin), r.size);
    }

    default public Point convertParentPointToScreen(Point point) {
        return this.isRoot() ? point : this.getParent().convertPointToScreen(point);
    }

    default public Point convertScreenPointToParent(Point point) {
        return this.isRoot() ? point : this.getParent().convertPointFromScreen(point);
    }

    default public Rect convertParentRectToScreen(Rect r) {
        return new Rect(this.convertParentPointToScreen(r.origin), r.size);
    }

    default public Rect convertScreenRectToParent(Rect r) {
        return new Rect(this.convertScreenPointToParent(r.origin), r.size);
    }

    default public Rect calculateGL11Frame() {
        Rect screenFrame = this.getRoot().getScreenFrame();
        Rect frame = this.convertParentRectToScreen(this.getFrame());
        Rect bottomLeftFrame = new Rect(new Point(frame.x(), screenFrame.height() - frame.y() - frame.height()), frame.size);
        double glWScale = this.getRoot().getMinecraft().func_228018_at_().func_198100_s();
        double glHScale = this.getRoot().getMinecraft().func_228018_at_().func_198100_s();
        Rect gl11Rect = new Rect(new Point((int)Math.round((double)bottomLeftFrame.x() * glWScale), (int)Math.round((double)bottomLeftFrame.y() * glHScale)), new Size((int)Math.round((double)bottomLeftFrame.width() * glWScale), (int)Math.round((double)bottomLeftFrame.height() * glHScale)));
        return gl11Rect;
    }

    default public Rect calculateAccumulatedFrame() {
        Rect screenSpaceFrame = this.getSubTree(n -> !n.isHidden()).stream().map(n -> n.convertParentRectToScreen(n.getFrame())).reduce(Rect.ZERO, Rect::union);
        return this.convertScreenRectToParent(screenSpaceFrame);
    }

    default public Rect calculateChildrenFrame() {
        List<RedUINode> subTree = this.getSubTree(n -> !n.isHidden());
        subTree.remove(0);
        Rect screenSpaceFrame = subTree.stream().map(n -> n.convertParentRectToScreen(n.getFrame())).reduce(Rect.ZERO, Rect::union);
        return this.convertScreenRectToParent(screenSpaceFrame);
    }

    default public List<RedUINode> hitTest(Point point) {
        LinkedList<RedUINode> hits = new LinkedList<RedUINode>();
        Point absPoint = this.convertParentPointToScreen(point);
        for (RedUINode child : this.getSubTree(n -> !n.isHidden())) {
            if (!child.checkHit(absPoint)) continue;
            hits.addFirst(child);
        }
        hits.sort(Comparator.comparingDouble(n -> n.getZPosition() * -1.0));
        return hits;
    }

    default public boolean checkHit(Point absPoint) {
        Point relatablePoint = this.convertScreenPointToParent(absPoint);
        return this.getFrame().contains(relatablePoint);
    }

    default public boolean isFirstHit(Point p) {
        Point screenPoint = this.convertParentPointToScreen(p);
        List<RedUINode> hits = this.getRoot().hitTest(screenPoint);
        return !hits.isEmpty() && hits.get(0) == this;
    }

    default public void pushZBy(double z) {
        for (RedUINode n2 : this.getSubTree(n -> true)) {
            n2.setZPosition(n2.getZPosition() + z);
        }
    }

    default public void pushZTo(double z) {
        double offset = z - this.getZPosition();
        this.pushZBy(offset);
    }

    default public void addChild(RedUINode child) {
        this.getOurChildren().add(child);
        child.setParent(this);
        RedUIRootNode root = this.getRoot();
        child.getSubTree(n -> true).forEach(n -> n.setRoot(root));
        child.onAddedToParent();
    }

    default public void removeFromParent() {
        this.getParent().getOurChildren().remove(this);
        this.setParent(null);
        this.getSubTree(n -> true).forEach(n -> n.setRoot(null));
    }

    default public void removeAllChildren() {
        ArrayList<RedUINode> children = new ArrayList<RedUINode>(this.getOurChildren());
        for (RedUINode child : children) {
            child.removeFromParent();
        }
    }

    default public boolean operateOnSubtree(Point p, SubtreeOp op, boolean consumed) {
        consumed |= op.operate(this, p, consumed);
        Point relativePoint = p.subtract(this.getPosition());
        for (RedUINode child : this.getOurChildren()) {
            consumed |= child.operateOnSubtree(relativePoint, op, consumed);
        }
        return consumed;
    }

    default public boolean operateOnZOrderedSubtree(Point p, SubtreeOp op, boolean consumed) {
        Point screenPoint = this.convertParentPointToScreen(p);
        for (RedUINode n2 : this.getZOrderedSubtree(n -> true, false)) {
            Point relativePoint = n2.convertScreenPointToParent(screenPoint);
            consumed |= op.operate(n2, relativePoint, consumed);
        }
        return consumed;
    }

    default public void renderBackForSubtree(MatrixStack stack, Point mouse, float partialFrame) {
        this.drawBack(stack, mouse, partialFrame);
        this.onSubTreePreDrawBack();
        for (RedUINode child : this.getZOrderedChildren(n -> !n.isHidden(), true)) {
            stack.func_227860_a_();
            Point relativeMouse = mouse.subtract(this.getPosition());
            Point relativePos = this.getPosition();
            double relativeZ = child.getRelativeZPosition();
            stack.func_227861_a_((double)relativePos.x, (double)relativePos.y, relativeZ);
            child.renderBackForSubtree(stack, relativeMouse, partialFrame);
            stack.func_227865_b_();
        }
        this.onSubTreePostDrawBack();
    }

    default public void renderFrontForSubtree(MatrixStack stack, Point mouse, float partialFrame) {
        this.drawFront(stack, mouse, partialFrame);
        this.onSubTreePreDrawFront();
        for (RedUINode child : this.getZOrderedChildren(n -> !n.isHidden(), true)) {
            stack.func_227860_a_();
            Point relativeMouse = mouse.subtract(this.getPosition());
            Point relativePos = this.getPosition();
            double relativeZ = child.getRelativeZPosition();
            stack.func_227861_a_((double)relativePos.x, (double)relativePos.y, relativeZ);
            child.renderFrontForSubtree(stack, relativeMouse, partialFrame);
            stack.func_227865_b_();
        }
        this.onSubTreePostDrawFront();
    }

    default public void onAddedToParent() {
    }

    default public void update() {
    }

    default public void frameUpdate(Point mouse, float partialFrame) {
    }

    default public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        return false;
    }

    default public boolean mouseReleased(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        return false;
    }

    default public boolean mouseDragged(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        return false;
    }

    default public boolean mouseScrolled(Point p, double scroll, boolean consumed) {
        return false;
    }

    default public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        return false;
    }

    default public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        return false;
    }

    default public boolean onCharTyped(char ch, int glfwFlags, boolean consumed) {
        return false;
    }

    default public void onSubTreePreDrawBack() {
    }

    default public void onSubTreePostDrawBack() {
    }

    default public void onSubTreePreDrawFront() {
    }

    default public void onSubTreePostDrawFront() {
    }

    default public void drawBack(MatrixStack stack, Point mouse, float partialFrame) {
    }

    default public void drawFront(MatrixStack stack, Point mouse, float partialFrame) {
    }

    default public void renderTooltip(MatrixStack stack, Point mouse, List<ITextProperties> tooltip) {
        if (tooltip.isEmpty()) {
            return;
        }
        Point screenOffset = this.getParent().getScreenOffset();
        Point mouseScreenSpace = screenOffset.add(mouse);
        stack.func_227860_a_();
        stack.func_227861_a_((double)(-screenOffset.x), (double)(-screenOffset.y), 0.0);
        GuiUtils.drawHoveringText((MatrixStack)stack, tooltip, (int)mouseScreenSpace.x, (int)mouseScreenSpace.y, (int)this.getRoot().getScreenFrame().width(), (int)this.getRoot().getScreenFrame().height(), (int)-1, (FontRenderer)this.getRoot().getFontRenderer());
        stack.func_227865_b_();
    }

    @FunctionalInterface
    public static interface SubtreeOp {
        public boolean operate(RedUINode var1, Point var2, boolean var3);
    }
}

