/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIRootNode;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;

public class RedUIContainerScreen<T extends Container>
extends ContainerScreen<T>
implements RedUIRootNode {
    private final List<RedUINode> children = new LinkedList<RedUINode>();
    private Rect frame;
    private Rect screenFrame;
    private double zPos = 0.0;
    private long lastClickTime = 0L;

    public RedUIContainerScreen(int backgroundWidth, int backgroundHeight, T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_146999_f = backgroundWidth;
        this.field_147000_g = backgroundHeight;
        this.frame = new Rect(Point.ZERO, new Size(backgroundWidth, backgroundHeight));
        this.screenFrame = Rect.ZERO;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.screenFrame = new Rect(Point.ZERO, new Size(this.field_230708_k_, this.field_230709_l_));
        Point framePos = new Point((this.screenFrame.width() - this.frame.width()) / 2, (this.screenFrame.height() - this.frame.height()) / 2);
        this.frame = new Rect(framePos, this.frame.size);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialFrame) {
        Point mousePoint = new Point(mouseX, mouseY);
        this.operateOnSubtree(mousePoint, (n, p, c) -> {
            n.frameUpdate(p, partialFrame);
            return false;
        }, false);
        RenderSystem.enableDepthTest();
        this.func_238468_a_(stack, this.getScreenFrame().x(), this.getScreenFrame().y(), this.getScreenFrame().width(), this.getScreenFrame().height(), -1072689136, -804253680);
        this.drawBackForSubtree(stack, new Point(mouseX, mouseY), partialFrame);
        super.func_230430_a_(stack, mouseX, mouseY, partialFrame);
        this.func_230459_a_(stack, mouseX, mouseY);
        this.drawFrontForSubtree(stack, new Point(mouseX, mouseY), partialFrame);
    }

    protected void func_230450_a_(MatrixStack stack, float partialFrame, int mouseX, int mouseY) {
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.getSubTree(n -> true).forEach(RedUINode::update);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231044_a_(double x, double y, int glfwMouseButton) {
        this.lastClickTime = System.currentTimeMillis();
        super.func_231044_a_(x, y, glfwMouseButton);
        boolean consumed = false;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseClicked(p, glfwMouseButton, c), consumed);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean consumed = super.func_231048_c_(x, y, button);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseReleased(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean func_231045_a_(double x, double y, int button, double dragX, double dragY) {
        boolean consumed = super.func_231045_a_(x, y, button, dragX, dragY);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseDragged(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        boolean consumed = super.func_231043_a_(x, y, scroll);
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseScrolled(p, scroll, c), consumed);
    }

    public boolean func_231042_a_(char keyPressed, int glfwFlags) {
        boolean consumed = super.func_231042_a_(keyPressed, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onCharTyped(keyPressed, glfwFlags, c), consumed);
    }

    public boolean func_231046_a_(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.func_231046_a_(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyPressed(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    public boolean func_223281_a_(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.func_223281_a_(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyReleased(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    @Override
    public Rect getScreenFrame() {
        return this.screenFrame;
    }

    @Override
    public List<RedUINode> getOurChildren() {
        return this.children;
    }

    @Override
    public Rect getFrame() {
        return this.frame;
    }

    @Override
    public Point getPosition() {
        return this.frame.origin;
    }

    @Override
    public double getZPosition() {
        return this.zPos;
    }

    @Override
    public void setZPosition(double zPosition) {
        this.zPos = zPosition;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.field_230707_j_;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }
}

