/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;

public class PVMMatrix {
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 viewMatrix = new Matrix4();
    private final Matrix4 orientationMatrix = new Matrix4();
    private final Vector3 forward = new Vector3();
    private final Vector3 right = new Vector3();
    private final Vector3 up = new Vector3();
    private final Vector3 cameraPosition = new Vector3(0.0, 0.0, 0.0);
    private double fovY;
    private double width;
    private double height;
    private double zNear;
    private double zFar;

    public void setProjection(double fovY, double windowWidth, double windowHeight, double zNear, double zFar) {
        this.fovY = fovY;
        this.width = windowWidth;
        this.height = windowHeight;
        this.zNear = zNear;
        this.zFar = zFar;
        this.projectionMatrix.setIdentity();
        PVMMatrix.perspective(this.projectionMatrix, fovY, windowWidth / windowHeight, zNear, zFar);
    }

    public void setView(double x, double y, double z, double xRot, double yRot) {
        this.cameraPosition.set(x, y, z);
        this.orientationMatrix.setIdentity();
        this.orientationMatrix.rotate(-yRot, Vector3.Y_POS);
        this.orientationMatrix.rotate(-xRot, Vector3.X_POS);
        this.forward.set(Vector3.Z_NEG);
        this.right.set(Vector3.X_POS);
        this.up.set(Vector3.Y_POS);
        this.orientationMatrix.apply(this.forward);
        this.orientationMatrix.apply(this.right);
        this.orientationMatrix.apply(this.up);
        this.viewMatrix.setIdentity();
        PVMMatrix.lookAt(this.viewMatrix, this.cameraPosition, this.cameraPosition.copy().add(this.forward), this.up);
        this.viewMatrix.transpose();
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4 getViewMatrix() {
        return this.viewMatrix;
    }

    public MatrixStack getModelViewMatrixStack() {
        MatrixStack stack = new MatrixStack();
        stack.func_227860_a_();
        stack.func_227866_c_().func_227870_a_().set(this.viewMatrix.toMatrix4f());
        return stack;
    }

    public Vector3 ndcToWorldCoordinates(double ndcX, double ndcY, double planeDist) {
        double maxY = Math.tan(this.fovY / 2.0) * planeDist;
        double maxX = maxY * this.width / this.height;
        double dx = ndcX * maxX;
        double dy = ndcY * maxY;
        Vector3 lookVec = new Vector3(dx, dy, -planeDist);
        this.orientationMatrix.apply(lookVec);
        lookVec.add(this.cameraPosition);
        return lookVec;
    }

    public static void perspective(Matrix4 m, double fovY, double aspect, double zNear, double zFar) {
        double tanHalfFovY = Math.tan(fovY / 2.0);
        double deltaZ = zFar - zNear;
        m.m00 = 1.0 / (aspect * tanHalfFovY);
        m.m11 = 1.0 / tanHalfFovY;
        m.m22 = -(zFar + zNear) / deltaZ;
        m.m32 = -1.0;
        m.m23 = -2.0 * (zFar * zNear) / deltaZ;
        m.m33 = 0.0;
    }

    public static void orthographic(Matrix4 m, double width, double height, double zNear, double zFar) {
        double deltaZ = zFar - zNear;
        m.m00 = 2.0 / width;
        m.m11 = 2.0 / height;
        m.m22 = -2.0 / deltaZ;
        m.m33 = 1.0;
        m.m03 = -1.0;
        m.m13 = 1.0;
        m.m23 = -(zFar + zNear) / deltaZ;
    }

    public static void lookAt(Matrix4 m, Vector3 eye, Vector3 center, Vector3 up) {
        Vector3 f = center.copy().subtract(eye).normalize();
        Vector3 s = f.copy().crossProduct(up).normalize();
        Vector3 u = s.copy().crossProduct(f);
        m.m00 = s.x;
        m.m10 = s.y;
        m.m20 = s.z;
        m.m01 = u.x;
        m.m11 = u.y;
        m.m21 = u.z;
        m.m02 = -f.x;
        m.m12 = -f.y;
        m.m22 = -f.z;
        m.m30 = -s.dotProduct(eye);
        m.m31 = -u.dotProduct(eye);
        m.m32 = f.dotProduct(eye);
    }
}

