/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIRootNode;

public abstract class AbstractGuiNode
implements RedUINode {
    private RedUIRootNode root;
    private RedUINode parent;
    private Rect frame = new Rect(Point.ZERO, Size.ZERO);
    private double zPos = 0.0;
    private boolean isHidden = false;
    private final List<RedUINode> children = new LinkedList<RedUINode>();

    public void setPosition(int x, int y) {
        this.frame = new Rect(new Point(x, y), this.frame.size);
    }

    public void setSize(int width, int height) {
        this.frame = new Rect(this.frame.origin, new Size(width, height));
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Override
    public RedUIRootNode getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(@Nullable RedUIRootNode root) {
        this.root = root;
    }

    @Override
    public RedUINode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable RedUINode parent) {
        this.parent = parent;
    }

    @Override
    public List<RedUINode> getOurChildren() {
        return this.children;
    }

    @Override
    public Rect getFrame() {
        return this.frame;
    }

    @Override
    public Point getPosition() {
        return this.frame.origin;
    }

    @Override
    public double getZPosition() {
        return this.zPos;
    }

    @Override
    public double getRelativeZPosition() {
        return this.zPos - this.getParent().getZPosition();
    }

    @Override
    public void setZPosition(double zPosition) {
        this.zPos = zPosition;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }
}

