/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import codechicken.lib.texture.TextureUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.GuiLib;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextProperties;

public abstract class AbstractButtonNode
extends AbstractGuiNode {
    public static final int BUTTON_STATE_DISABLED = 0;
    public static final int BUTTON_STATE_IDLE = 1;
    public static final int BUTTON_STATE_HIGHLIGHT = 2;

    protected abstract void onButtonClicked();

    protected boolean isButtonDisabled() {
        return false;
    }

    protected void buildTooltip(List<ITextProperties> tooltip) {
    }

    protected int getButtonState(boolean mouseover) {
        return this.isButtonDisabled() ? 0 : (mouseover ? 2 : 1);
    }

    @Override
    public void drawBack(MatrixStack stack, Point mouse, float partialFrame) {
        boolean mouseover = this.getFrame().contains(mouse) && this.isFirstHit(mouse);
        TextureUtils.changeTexture((ResourceLocation)GuiLib.WIDGETS_TEXTURE);
        int state = this.getButtonState(mouseover);
        this.drawMCButton(stack, state);
        this.drawButtonBody(stack, mouseover);
    }

    @Override
    public void drawFront(MatrixStack stack, Point mouse, float partialFrame) {
        if (!this.isFirstHit(mouse)) {
            return;
        }
        LinkedList<ITextProperties> tooltip = new LinkedList<ITextProperties>();
        this.buildTooltip(tooltip);
        if (!tooltip.isEmpty()) {
            this.renderTooltip(stack, mouse, tooltip);
        }
    }

    @Override
    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (!consumed && !this.isButtonDisabled() && this.isFirstHit(p)) {
            this.getRoot().getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onButtonClicked();
            return true;
        }
        return false;
    }

    protected void drawMCButton(MatrixStack stack, int state) {
        TextureUtils.changeTexture((ResourceLocation)GuiLib.WIDGETS_TEXTURE);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getFrame().width();
        int height = this.getFrame().height();
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)x, (int)y, (float)0.0f, (float)(46 + state * 20), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(x + width / 2), (int)y, (float)(200.0f - (float)width / 2.0f), (float)(46 + state * 20), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)x, (int)(y + height / 2), (float)0.0f, (float)((float)(46 + state * 20 + 20) - (float)height / 2.0f), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(x + width / 2), (int)(y + height / 2), (float)(200.0f - (float)width / 2.0f), (float)((float)(46 + state * 20 + 20) - (float)height / 2.0f), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
    }

    protected abstract void drawButtonBody(MatrixStack var1, boolean var2);
}

