/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;

public class VecLib {
    public static IndexedCuboid6[] buildCubeArray(int xSize, int zSize, Cuboid6 box, Vector3 expand) {
        box.min.multiply(0.0625);
        box.max.multiply(0.0625);
        expand.multiply(0.0625);
        IndexedCuboid6[] cuboids = new IndexedCuboid6[xSize * zSize];
        for (int i = 0; i < cuboids.length; ++i) {
            int x = i % xSize;
            int z = i / zSize;
            double dx = (box.max.x - box.min.x) / (double)xSize;
            double dz = (box.max.z - box.min.z) / (double)zSize;
            Vector3 min1 = new Vector3(box.min.x + dx * (double)x, box.min.y, box.min.z + dz * (double)z);
            Vector3 max1 = new Vector3(min1.x + dx, box.max.y, min1.z + dz);
            cuboids[i] = new IndexedCuboid6((Object)i, new Cuboid6(min1, max1).expand(expand));
        }
        return cuboids;
    }

    public static Transformation orientT(int orient) {
        Transformation t = Rotation.sideOrientation((int)(orient % 24 >> 2), (int)(orient & 3));
        if (orient >= 24) {
            t = new Scale(-1.0, 1.0, 1.0).with(t);
        }
        return t.at(Vector3.CENTER);
    }
}

