/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InventoryLib {
    public static void injectItemStack(IInventory inventory, ItemStack stack, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, 0, inventory.func_70302_i_(), reverse);
    }

    public static void injectItemStack(IInventory inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, true);
        if (!stack.func_190926_b()) {
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, false);
        }
    }

    public static boolean injectAllItemStacks(IInventory inventory, NonNullList<ItemStack> stacks, boolean reverse) {
        return InventoryLib.injectAllItemStacks(inventory, stacks, 0, inventory.func_70302_i_(), reverse);
    }

    public static boolean injectAllItemStacks(IInventory inventory, NonNullList<ItemStack> stacks, int startIndex, int endIndex, boolean reverse) {
        boolean allInjected = true;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse);
            if (stack.func_190926_b()) {
                stacks.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            allInjected = false;
        }
        return allInjected;
    }

    private static void injectItemStack(IInventory inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse, boolean mergeOnly) {
        for (int i = startIndex; i < endIndex; ++i) {
            int index = reverse ? endIndex - i - 1 : i;
            ItemStack stackInSlot = inventory.func_70301_a(index);
            if (stackInSlot.func_190926_b()) {
                if (mergeOnly) continue;
                inventory.func_70299_a(index, stack.func_77946_l());
                stack.func_190920_e(0);
            } else if (InventoryLib.areStackable(stack, stackInSlot)) {
                int maxStackSize = Math.min(inventory.func_70297_j_(), stackInSlot.func_77976_d());
                int spaceRemaining = Math.max(0, maxStackSize - stackInSlot.func_190916_E());
                int amountToInsert = Math.min(spaceRemaining, stack.func_190916_E());
                stack.func_190918_g(amountToInsert);
                stackInSlot.func_190917_f(amountToInsert);
                inventory.func_70299_a(index, stackInSlot);
            }
            if (stack.func_190926_b()) break;
        }
    }

    public static boolean areStackable(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b) && a.func_77976_d() > 1 && b.func_77976_d() > 1;
    }

    public static void addPlayerInventory(PlayerInventory playerInventory, int x, int y, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((IInventory)playerInventory, 9, x, y, 9, 3, slotConsumer);
        InventoryLib.addInventory((IInventory)playerInventory, 0, x, y + 58, 9, 1, slotConsumer);
    }

    public static void addPlayerInventory(PlayerInventory playerInventory, int x, int y, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((IInventory)playerInventory, 9, x, y, 9, 3, slotFactory, slotConsumer);
        InventoryLib.addInventory((IInventory)playerInventory, 0, x, y + 58, 9, 1, slotFactory, slotConsumer);
    }

    public static void addInventory(IInventory inventory, int i, int x, int y, int columns, int rows, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory(inventory, i, x, y, columns, rows, Slot::new, slotConsumer);
    }

    public static void addInventory(IInventory inventory, int i, int x, int y, int columns, int rows, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                slotConsumer.accept(slotFactory.createSlot(inventory, i + (r * columns + c), x + c * 18, y + r * 18));
            }
        }
    }

    @FunctionalInterface
    public static interface SlotFactory {
        public Slot createSlot(IInventory var1, int var2, int var3, int var4);
    }
}

