/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public interface IBlockEventTile {
    public World getBlockLevel();

    public BlockPos getBlockPosition();

    default public void onBlockPlaced(LivingEntity player, ItemStack item) {
    }

    default public void onBlockStateReplaced(BlockState newState) {
    }

    default public void onBlockRemoved() {
    }

    default public void loadBlockState(BlockState state) {
    }

    default public BlockState storeBlockState(BlockState defaultState) {
        return defaultState;
    }

    default public VoxelShape getOutlineShape() {
        return VoxelShapeCache.getShape((Cuboid6)Cuboid6.full);
    }

    default public VoxelShape getCollisionShape() {
        return this.getOutlineShape();
    }

    default public VoxelShape getCullingShape() {
        return this.getOutlineShape();
    }

    default public VoxelShape getRayTraceShape() {
        return this.getOutlineShape();
    }

    default public float getExplosionResistance(Entity exploder, Explosion explosion) {
        return 0.0f;
    }

    default public float getPlayerRelativeBlockHardness(PlayerEntity player) {
        return 0.033333335f;
    }

    default public int getLightValue() {
        return 0;
    }

    default public boolean isFireSource(int side) {
        return false;
    }

    default public ActionResultType onBlockActivated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    default public void onBlockClicked(PlayerEntity player) {
    }

    default public void onEntityCollision(Entity entity) {
    }

    default public void onEntityWalk(Entity entity) {
    }

    default public void onNeighborBlockChanged(BlockPos neighborPos) {
    }

    default public void onNeighborTileChanged(BlockPos neighborPos) {
    }

    default public boolean getWeakChanges() {
        return false;
    }

    default public boolean canRedstoneConnect(int side) {
        return false;
    }

    default public int getStrongPower(int side) {
        return 0;
    }

    default public int getWeakPower(int side) {
        return 0;
    }

    public void saveToNBT(CompoundNBT var1);

    public void loadFromNBT(CompoundNBT var1);

    public void writeDesc(MCDataOutput var1);

    public void readDesc(MCDataInput var1);
}

