/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.init.CoreReferences;
import mrtjp.projectred.core.inventory.container.ElectrotineGeneratorContainer;
import mrtjp.projectred.core.power.ILowLoadMachine;
import mrtjp.projectred.core.power.ILowLoadPowerLine;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BasePoweredTile;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ElectrotineGeneratorTile
extends BasePoweredTile
implements ILowLoadMachine {
    protected final PowerConductor conductor = new PowerConductor(this, 0.01, 160.0);
    private int chargeFlow = 0;
    private final ElectrotineGeneratorInventory inventory = new ElectrotineGeneratorInventory();
    private final LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorTile() {
        super(CoreReferences.ELECTROTINE_GENERATOR_TILE);
    }

    @Override
    public void saveToNBT(CompoundNBT tag) {
        super.saveToNBT(tag);
        this.conductor.save(tag);
        tag.func_218657_a("inventory", (INBT)this.inventory.func_70487_g());
        tag.func_74768_a("burnTime", this.burnTimeRemaining);
        tag.func_74768_a("stored", this.powerStored);
    }

    @Override
    public void loadFromNBT(CompoundNBT tag) {
        super.loadFromNBT(tag);
        this.conductor.load(tag);
        this.inventory.func_70486_a(tag.func_150295_c("inventory", 10));
        this.burnTimeRemaining = tag.func_74762_e("burnTime");
        this.powerStored = tag.func_74762_e("stored");
    }

    @Override
    public void loadBlockState(BlockState state) {
        super.loadBlockState(state);
    }

    @Override
    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).func_206870_a((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.canConductorWork()))).func_206870_a((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.burnTimeRemaining > 0));
    }

    @Override
    public ActionResultType onBlockActivated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.func_145831_w().field_72995_K) {
            ServerUtils.openContainer((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, p) -> new ElectrotineGeneratorContainer(inv, this, id), (ITextComponent)new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a())), p -> p.writePos(this.func_174877_v()));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        ElectrotineGeneratorTile.dropInventory((IInventory)this.inventory, this.func_145831_w(), Vector3.fromBlockPos((BlockPos)this.func_174877_v()));
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.conductor.tick();
        this.chargeFlow <<= 1;
        if (this.canConductorWork()) {
            this.chargeFlow |= 1;
        }
        this.tryBurnDust();
        this.tryChargeStorage();
        this.tryChargeConductor();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.updateRendersIfNeeded();
        }
    }

    @Override
    public PowerConductor getConductor(int dir) {
        return this.conductor;
    }

    @Override
    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (part instanceof ILowLoadPowerLine) {
            return true;
        }
        return part instanceof ILowLoadMachine;
    }

    private void tryBurnDust() {
        ItemStack removedDust;
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining < this.getBurnUseOnCharge() && !(removedDust = this.inventory.func_70298_a(0, 1)).func_190926_b()) {
            int addedBurnTime = this.getBurnTimeForDust(removedDust);
            this.burnTimeRemaining = Math.min(this.getMaxBurnTime(), this.burnTimeRemaining + addedBurnTime);
        }
    }

    private void tryChargeStorage() {
        if (this.burnTimeRemaining == 0) {
            return;
        }
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining >= this.getBurnUseOnCharge()) {
            ++this.powerStored;
            this.burnTimeRemaining -= this.getBurnUseOnCharge();
        } else {
            this.burnTimeRemaining -= Math.min(this.burnTimeRemaining, this.getBurnUseOnIdle());
        }
    }

    private void tryChargeConductor() {
        if (this.getConductorCharge() < this.getDrawFloor() && this.powerStored > 0) {
            int n = Math.min(this.getDrawFloor() - this.getConductorCharge(), this.getDrawSpeed()) / 10;
            n = Math.min(n, this.powerStored);
            this.conductor.applyPower(n * 1000);
            this.powerStored -= n;
        }
    }

    private void updateRendersIfNeeded() {
        boolean lastWorking = (Boolean)this.func_195044_w().func_177229_b((Property)ProjectRedBlock.WORKING);
        boolean lastCharged = (Boolean)this.func_195044_w().func_177229_b((Property)ProjectRedBlock.CHARGED);
        boolean isWorking = this.burnTimeRemaining > 0;
        boolean isCharged = this.canConductorWork();
        if (lastWorking != isWorking || lastCharged != isCharged) {
            this.pushBlockState();
        }
    }

    protected int getBurnTimeForDust(ItemStack dust) {
        return 2750;
    }

    public int getBurnUseOnCharge() {
        return 10;
    }

    public int getBurnUseOnIdle() {
        return 1;
    }

    public int getDrawSpeed() {
        return 100;
    }

    public int getDrawFloor() {
        return 1200;
    }

    public int getMaxStorage() {
        return 800;
    }

    public int getMaxBurnTime() {
        return 2750;
    }

    @Override
    public int getConductorCharge() {
        return (int)(this.conductor.getVoltage() * 10.0);
    }

    @Override
    public int getConductorFlow() {
        return this.chargeFlow;
    }

    @Override
    public boolean canConductorWork() {
        return this.getConductorCharge() > 600;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class ElectrotineGeneratorInventory
    extends Inventory {
        public ElectrotineGeneratorInventory() {
            super(1);
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return stack.func_77973_b() == CoreReferences.ELECTROTINE_DUST_ITEM;
        }
    }
}

