/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BaseConnectableTile;
import mrtjp.projectred.core.tile.IPoweredTile;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public abstract class BasePoweredTile
extends BaseConnectableTile
implements IPoweredTile,
ITickableTileEntity {
    private final List<PowerConductor> connectedConductors = new LinkedList<PowerConductor>();
    private boolean cacheInvalid = true;

    public BasePoweredTile(TileEntityType<?> type) {
        super(type);
    }

    protected void invalidateConductorCache() {
        this.cacheInvalid = true;
    }

    @Override
    public void onMaskChanged() {
        super.onMaskChanged();
        this.cacheInvalid = true;
    }

    @Override
    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        this.cacheInvalid = true;
    }

    @Override
    public long getTime() {
        return this.field_145850_b.func_82737_E();
    }

    @Override
    public List<PowerConductor> getConnectedConductors() {
        if (this.cacheInvalid) {
            this.recacheConductors();
            this.cacheInvalid = false;
        }
        return this.connectedConductors;
    }

    private void recacheConductors() {
        int s;
        this.connectedConductors.clear();
        for (s = 0; s < 6; ++s) {
            for (int r = 0; r < 4; ++r) {
                PowerConductor c = IPoweredTile.getExternalConductorForFaceConn(this, s, r);
                if (c == null) continue;
                this.connectedConductors.add(c);
            }
        }
        for (s = 0; s < 6; ++s) {
            PowerConductor c = IPoweredTile.getExternalConductorForCenterConn(this, s);
            if (c == null) continue;
            this.connectedConductors.add(c);
        }
    }

    public abstract int getConductorCharge();

    public abstract int getConductorFlow();

    public abstract boolean canConductorWork();
}

