/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.core.tile.IConnectableTile;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import mrtjp.projectred.core.tile.ProjectRedTile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public abstract class BaseConnectableTile
extends ProjectRedTile
implements IConnectableTile,
IPacketReceiverTile {
    public static final int PACKET_CONN_MAP = 2;
    private long connMap = 0L;

    public BaseConnectableTile(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public long getConnMap() {
        return this.connMap;
    }

    @Override
    public void setConnMap(long connMap) {
        this.connMap = connMap;
    }

    @Override
    public void saveToNBT(CompoundNBT tag) {
        tag.func_74772_a("connMap", this.connMap);
    }

    @Override
    public void loadFromNBT(CompoundNBT tag) {
        this.connMap = tag.func_74763_f("connMap");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeLong(this.connMap);
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.connMap = in.readLong();
    }

    @Override
    public void receiveUpdateFromServer(int key, MCDataInput input) {
        if (key == 2) {
            this.connMap = input.readLong();
        }
    }

    @Override
    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayerEntity player) {
    }

    protected boolean clientNeedsMask() {
        return false;
    }

    protected void sendConnUpdate() {
        if (this.clientNeedsMask()) {
            this.sendUpdateToPlayersWatchingChunk(2, out -> out.writeLong(this.connMap));
        }
    }

    @Override
    public void onMaskChanged() {
        this.sendConnUpdate();
    }

    @Override
    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        if (!this.getBlockLevel().field_72995_K) {
            this.updateExternals();
        }
    }

    @Override
    public void onBlockPlaced(LivingEntity player, ItemStack item) {
        super.onBlockPlaced(player, item);
        if (!this.getBlockLevel().field_72995_K) {
            this.updateExternals();
        }
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        if (!this.getBlockLevel().field_72995_K) {
            this.notifyConnectedExternals();
        }
    }
}

