/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import codechicken.multipart.api.part.TMultiPart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.part.IPropagationHooks;
import mrtjp.projectred.core.part.IPropagationPart;

public interface IPropagationFacePart
extends IPropagationHooks,
IConnectableFacePart {
    default public void propagateOther(int mode) {
    }

    @Override
    default public void propagateForward(IPropagationPart prev, int mode) {
        if (mode != 3) {
            RedstonePropagator.addPartChange((TMultiPart)this);
        }
        for (int r = 0; r < 4; ++r) {
            if ((this.getPropagationMask() & 1 << r) == 0) continue;
            if (this.maskConnectsInside(r)) {
                this.propagateTo(this.getInternal(r), prev, mode);
                continue;
            }
            if (this.maskConnectsStraight(r)) {
                if (this.propagateTo(this.getStraight(r), prev, mode)) continue;
                RedstonePropagator.addNeighborChange(this.level(), this.posOfStraight(r));
                continue;
            }
            if (!this.maskConnectsCorner(r) || this.propagateTo(this.getCorner(r), prev, mode)) continue;
            RedstonePropagator.addNeighborChange(this.level(), this.posOfCorner(r));
        }
        if (this.maskConnectsCenter()) {
            this.propagateTo(this.getCenter(), prev, mode);
        }
        this.propagateOther(mode);
    }

    @Override
    default public void propagateBackward(IPropagationPart prev, int mode) {
        if (this.shouldPropagate(prev, mode)) {
            RedstonePropagator.propagateTo(prev, this, mode);
        }
    }

    default public int getPropagationMask() {
        return 15;
    }

    default public boolean propagateTo(IConnectable to, IPropagationPart prev, int mode) {
        if (to != null) {
            IPropagationPart part;
            if (to == prev) {
                return false;
            }
            if (to instanceof IPropagationPart && this.shouldPropagate(part = (IPropagationPart)((Object)to), mode)) {
                RedstonePropagator.propagateTo(part, this, mode);
                return true;
            }
        }
        return false;
    }
}

