/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.init.CoreReferences;
import mrtjp.projectred.core.inventory.container.BasePoweredTileContainer;
import mrtjp.projectred.core.tile.ElectrotineGeneratorTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ElectrotineGeneratorContainer
extends BasePoweredTileContainer {
    public static ICCLContainerFactory<ElectrotineGeneratorContainer> FACTORY = (windowId, inventory, packet) -> {
        TileEntity tile = inventory.field_70458_d.field_70170_p.func_175625_s(packet.readPos());
        if (!(tile instanceof ElectrotineGeneratorTile)) {
            return null;
        }
        return new ElectrotineGeneratorContainer(inventory, (ElectrotineGeneratorTile)tile, windowId);
    };
    private final PlayerInventory playerInventory;
    private final ElectrotineGeneratorTile tile;
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorContainer(PlayerInventory playerInventory, ElectrotineGeneratorTile tile, int windowId) {
        super(CoreReferences.ELECTROTINE_GENERATOR_CONTAINER, windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory(playerInventory, 8, 89, arg_0 -> ((ElectrotineGeneratorContainer)this).func_75146_a(arg_0));
        this.addElectrotineGeneratorInventory();
    }

    private void addElectrotineGeneratorInventory() {
        this.func_75146_a(new Slot((IInventory)this.tile.getInventory(), 0, 134, 42){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == CoreReferences.ELECTROTINE_DUST_ITEM;
            }
        });
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        boolean needsBurnTimeRemaining = this.burnTimeRemaining != this.tile.getBurnTimeRemaining();
        boolean needsPowerStored = this.powerStored != this.tile.getPowerStored();
        this.burnTimeRemaining = this.tile.getBurnTimeRemaining();
        this.powerStored = this.tile.getPowerStored();
        for (IContainerListener listener : this.field_75149_d) {
            if (needsBurnTimeRemaining) {
                listener.func_71112_a((Container)this, 110, this.burnTimeRemaining);
            }
            if (!needsPowerStored) continue;
            listener.func_71112_a((Container)this, 111, this.powerStored);
        }
    }

    @Override
    public void func_75137_b(int id, int value) {
        switch (id) {
            case 110: {
                this.burnTimeRemaining = value;
                break;
            }
            case 111: {
                this.powerStored = value;
                break;
            }
            default: {
                super.func_75137_b(id, value);
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack originalStack = stack.func_77946_l();
        if (this.isFuel(slotIndex) ? !this.moveToEntireInventory(stack, false) : (stack.func_77973_b() == CoreReferences.ELECTROTINE_DUST_ITEM ? !this.moveToFuel(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stack.func_190916_E() == originalStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(player, stack);
        return originalStack;
    }

    public int getBurnTimeScaled(int scale) {
        return this.burnTimeRemaining == 0 ? 0 : scale * this.burnTimeRemaining / this.tile.getMaxBurnTime();
    }

    public int getPowerStoredScaled(int scale) {
        return this.powerStored == 0 ? 0 : scale * this.powerStored / this.tile.getMaxStorage();
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public boolean isChargingStorage() {
        return this.burnTimeRemaining > this.tile.getBurnUseOnCharge() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean isChargingConductor() {
        return this.condCharge < this.tile.getDrawFloor() && (this.powerStored > 0 || this.burnTimeRemaining > this.tile.getBurnUseOnCharge());
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isFuel(int slotIndex) {
        return slotIndex == 36;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.func_75135_a(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.func_75135_a(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.func_75135_a(stack, 0, 36, reverse);
    }

    private boolean moveToFuel(ItemStack stack, boolean reverse) {
        return this.func_75135_a(stack, 36, 37, reverse);
    }
}

