/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory.container;

import javax.annotation.Nullable;
import mrtjp.projectred.core.tile.BasePoweredTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;

public class BasePoweredTileContainer
extends Container {
    private final BasePoweredTile tile;
    protected int condCharge;
    protected int condFlow;

    public BasePoweredTileContainer(@Nullable ContainerType<?> containerType, int windowId, BasePoweredTile tile) {
        super(containerType, windowId);
        this.tile = tile;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return !this.tile.func_145837_r();
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean needsCharge = this.tile.getConductorCharge() != this.condCharge;
        boolean needsFlow = this.tile.getConductorFlow() != this.condFlow;
        this.condCharge = this.tile.getConductorCharge();
        this.condFlow = this.tile.getConductorFlow();
        for (IContainerListener listener : this.field_75149_d) {
            if (needsCharge) {
                listener.func_71112_a((Container)this, 100, this.tile.getConductorCharge());
            }
            if (!needsFlow) continue;
            listener.func_71112_a((Container)this, 101, this.tile.getConductorFlow() & 0xFFFF);
            listener.func_71112_a((Container)this, 102, this.tile.getConductorFlow() >> 16 & 0xFFFF);
        }
    }

    public void func_75137_b(int id, int value) {
        switch (id) {
            case 100: {
                this.condCharge = value;
                break;
            }
            case 101: {
                this.condFlow = this.condFlow & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 102: {
                this.condFlow = this.condFlow & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            default: {
                super.func_75137_b(id, value);
            }
        }
    }

    public int getChargeScaled(int scale) {
        return Math.min(scale, scale * this.condCharge / 1000);
    }

    public int getFlowScaled(int scale) {
        return scale * Integer.bitCount(this.condFlow) / 32;
    }

    public boolean canConductorWork() {
        return this.condCharge > 600;
    }

    public boolean isFlowFull() {
        return this.condFlow == -1;
    }
}

