/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.data;

import javax.annotation.Nonnull;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.init.CoreReferences;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CoreBlockStateModelProvider
extends BlockStateProvider {
    public CoreBlockStateModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "projectred-core", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "ProjectRed-Core Block State Models";
    }

    protected void registerStatesAndModels() {
        this.quadStateFrontFacedPoweredMachineModel(CoreReferences.ELECTROTINE_GENERATOR_BLOCK);
    }

    private void quadStateFrontFacedPoweredMachineModel(Block block) {
        this.addRotatablePoweredMachineVariants(block, (ModelFile)this.createFrontFacedPoweredMachineModel(block, 0), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 1), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 2), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 3));
    }

    private void addRotatablePoweredMachineVariants(Block block, ModelFile idleModel, ModelFile chargedModel, ModelFile workingModel, ModelFile chargedWorkingModel) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int r = (Integer)state.func_177229_b((Property)ProjectRedBlock.ROTATION);
            boolean isWorking = (Boolean)state.func_177229_b((Property)ProjectRedBlock.WORKING);
            boolean isCharged = (Boolean)state.func_177229_b((Property)ProjectRedBlock.CHARGED);
            ModelFile modelFile = !isWorking && !isCharged ? idleModel : (isWorking && !isCharged ? workingModel : (!isWorking && isCharged ? chargedModel : chargedWorkingModel));
            return ConfiguredModel.builder().modelFile(modelFile).rotationY(r * 90).build();
        });
    }

    private BlockModelBuilder createFrontFacedPoweredMachineModel(Block block, int state) {
        String texture = block.getRegistryName().func_110623_a();
        String modelName = texture + (state > 0 ? "_state" + state : "");
        return (BlockModelBuilder)this.models().orientableWithBottom(modelName, this.modLoc("block/" + texture + "_side"), this.modLoc("block/" + texture + "_front_" + state), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"));
    }
}

