/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class HaloRenderer {
    public static final RenderType HALO_RENDER_TYPE = RenderType.func_228633_a_((String)"projectred-core:halo", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)8192, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228512_d_).func_228724_a_(RenderState.field_228523_o_).func_228714_a_(RenderState.field_228534_z_).func_228721_a_(RenderState.field_239236_S_).func_228728_a_(false));
    private static final LinkedList<WorldLight> worldLights = new LinkedList();

    public static void addLight(BlockPos pos, int colour, Cuboid6 box) {
        worldLights.add(new WorldLight(pos, colour, box));
    }

    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        WorldLight light = null;
        while ((light = worldLights.poll()) != null) {
            System.out.print("RENDER: " + light.pos.toString() + ": " + light.box.toString());
        }
    }

    public static void prepareRenderState(CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer buffers) {
        ccrs.reset();
        ccrs.bind(HALO_RENDER_TYPE, buffers, mStack);
    }

    public static void renderToCCRS(CCRenderState ccrs, Cuboid6 cuboid, int colour, Transformation t) {
        ccrs.setPipeline(new IVertexOperation[]{t});
        ccrs.baseColour = EnumColour.values()[colour].rgba();
        ccrs.alphaOverride = 160;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)cuboid, (int)0);
    }

    public static void renderHalo(CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer buffers, Cuboid6 cuboid, int colour, Vector3 pos) {
        HaloRenderer.prepareRenderState(ccrs, mStack, buffers);
        HaloRenderer.renderToCCRS(ccrs, cuboid, colour, (Transformation)pos.translation());
    }

    private static class WorldLight {
        public BlockPos pos;
        public int colour;
        public Cuboid6 box;

        public WorldLight(BlockPos pos, int colour, Cuboid6 box) {
            this.pos = pos;
            this.colour = colour;
            this.box = box;
        }
    }
}

