/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.block;

import javax.annotation.Nullable;
import mrtjp.projectred.core.tile.IBlockEventTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class ProjectRedBlock
extends Block {
    public static final IntegerProperty SIDE = IntegerProperty.func_177719_a((String)"side", (int)0, (int)5);
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty CHARGED = BooleanProperty.func_177716_a((String)"charged");
    public static final BooleanProperty WORKING = BooleanProperty.func_177716_a((String)"working");
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final AbstractBlock.Properties WOODEN_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
    public static final AbstractBlock.Properties STONE_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d);

    public ProjectRedBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected abstract TileEntity createTileEntityInstance(BlockState var1, IBlockReader var2);

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity tile = this.createTileEntityInstance(state, world);
        if (tile instanceof IBlockEventTile) {
            ((IBlockEventTile)tile).loadBlockState(state);
        }
        return tile;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBlockEventTile) {
            ((IBlockEventTile)tile).onNeighborBlockChanged(neighbor);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBlockEventTile) {
            ((IBlockEventTile)tile).onNeighborTileChanged(neighbor);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBlockEventTile) {
            return ((IBlockEventTile)tile).onBlockActivated(player, hand, hit);
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBlockEventTile) {
            if (oldState.func_203425_a(newState.func_177230_c())) {
                ((IBlockEventTile)tile).onBlockStateReplaced(newState);
            } else {
                ((IBlockEventTile)tile).onBlockRemoved();
            }
        }
        super.func_196243_a(oldState, world, pos, newState, isMoving);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBlockEventTile) {
            ((IBlockEventTile)tile).onBlockPlaced(player, stack);
        }
    }
}

