/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.gui.SimpleItemGroup;
import codechicken.lib.util.SneakyUtils;
import codechicken.multipart.api.MultiPartType;
import mrtjp.projectred.compatibility.ComputerCraftCompatibility;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.data.CoreBlockStateModelProvider;
import mrtjp.projectred.core.data.CoreItemModelProvider;
import mrtjp.projectred.core.data.CoreItemTagsProvider;
import mrtjp.projectred.core.data.CoreLanguageProvider;
import mrtjp.projectred.core.data.CoreLootTableProvider;
import mrtjp.projectred.core.data.CoreRecipeProvider;
import mrtjp.projectred.core.init.CoreBlocks;
import mrtjp.projectred.core.init.CoreClientInit;
import mrtjp.projectred.core.init.CoreContainers;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreParts;
import mrtjp.projectred.core.init.CoreReferences;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.OptionalMod;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectred-core")
public class ProjectRedCore {
    public static final String MOD_ID = "projectred-core";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred-core");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred-core");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"projectred-core");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"projectred-core");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred-core");
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"projectred-core");
    public static final DeferredRegister<MultiPartType<?>> PARTS = DeferredRegister.create((Class)((Class)SneakyUtils.unsafeCast(MultiPartType.class)), (String)"projectred-core");
    public static final SimpleItemGroup CORE_GROUP = new SimpleItemGroup("projectred-core", () -> new ItemStack((IItemProvider)CoreReferences.RED_ALLOY_INGOT_ITEM));

    public ProjectRedCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> CoreClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        PARTS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CoreNetwork.init();
        Configurator.load();
        if (Configurator.compat_CCBundledCable) {
            OptionalMod.of((String)"computercraft").ifPresent(mod -> ComputerCraftCompatibility.init(mod));
        }
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new CoreBlockStateModelProvider(generator, fileHelper));
            generator.func_200390_a((IDataProvider)new CoreItemModelProvider(generator, fileHelper));
            generator.func_200390_a((IDataProvider)new CoreLanguageProvider(generator));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new CoreRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new CoreLootTableProvider(generator));
            generator.func_200390_a((IDataProvider)new CoreItemTagsProvider(generator, fileHelper));
        }
    }

    static {
        CoreBlocks.register();
        CoreItems.register();
        CoreContainers.register();
        CoreParts.register();
    }
}

