/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PlacementLib {
    private static List<Block> wireWhiteList = new LinkedList<Block>();
    private static List<Block> gateWhiteList = new LinkedList<Block>();

    public static boolean canPlaceWireOnSide(World world, BlockPos pos, Direction side) {
        BlockState state = world.func_180495_p(pos);
        if (wireWhiteList.contains(state.func_177230_c())) {
            return true;
        }
        return state.func_224755_d((IBlockReader)world, pos, side);
    }

    public static boolean canPlaceGateOnSide(World world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceWireOnSide(world, pos, side)) {
            return true;
        }
        BlockState state = world.func_180495_p(pos);
        return gateWhiteList.contains(state.func_177230_c());
    }

    public static boolean canPlaceLight(World world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceWireOnSide(world, pos, side)) {
            return true;
        }
        if (side == Direction.UP) {
            return Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)side);
        }
        return false;
    }

    public static void dropTowardsPlayer(World world, BlockPos pos, ItemStack stack, PlayerEntity player) {
        if (world.field_72995_K || !world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            return;
        }
        Vector3 bpos = Vector3.fromBlockPos((BlockPos)pos);
        Vector3 d = new Vector3(player.func_213303_ch()).subtract(bpos).normalize();
        Vector3 vel = d.copy().multiply(8.0);
        Vector3 tpos = bpos.add(Vector3.CENTER).add(d.copy().multiply(1.25));
        ItemEntity item = new ItemEntity(world, tpos.x, tpos.y, tpos.z, stack);
        vel.multiply(0.02);
        item.func_213293_j(vel.x, vel.y, vel.z);
        item.func_174867_a(0);
        world.func_217376_c((Entity)item);
    }

    static {
        wireWhiteList.add(Blocks.field_150426_aN);
        wireWhiteList.add(Blocks.field_150331_J);
        wireWhiteList.add(Blocks.field_150320_F);
        wireWhiteList.add(Blocks.field_150332_K);
        gateWhiteList.add(Blocks.field_150359_w);
    }
}

