/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FaceLookup {
    public final World world;
    public final BlockPos pos;
    public final int side;
    public final int r;
    public final BlockState state;
    public final Block block;
    public final TileEntity tile;
    public final TMultiPart part;
    public final BlockPos otherPos;
    public final int otherSide;
    public final int otherRotation;

    public FaceLookup(World world, BlockPos pos, int side, int r, BlockState state, TileEntity tile, TMultiPart part, BlockPos otherPos, int otherSide, int otherRotation) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.r = r;
        this.state = state;
        this.block = state.func_177230_c();
        this.tile = tile;
        this.part = part;
        this.otherPos = otherPos;
        this.otherSide = otherSide;
        this.otherRotation = otherRotation;
    }

    public static FaceLookup lookupCorner(World world, BlockPos pos, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        int otherSide = absDir ^ 1;
        int otherRotation = Rotation.rotationTo((int)(absDir ^ 1), (int)(side ^ 1));
        BlockPos pos2 = pos.func_177972_a(Direction.values()[absDir]).func_177972_a(Direction.values()[side]);
        BlockState state = world.func_180495_p(pos2);
        TileEntity tile = world.func_175625_s(pos2);
        TMultiPart part = null;
        if (tile instanceof TileMultiPart) {
            part = ((TileMultiPart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupStraight(World world, BlockPos pos, int side, int r) {
        int otherSide = side;
        int otherRotation = (r + 2) % 4;
        BlockPos pos2 = pos.func_177972_a(Direction.values()[Rotation.rotateSide((int)side, (int)r)]);
        BlockState state = world.func_180495_p(pos2);
        TileEntity tile = world.func_175625_s(pos2);
        TMultiPart part = null;
        if (tile instanceof TileMultiPart) {
            part = ((TileMultiPart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideFace(World world, BlockPos pos, int side, int r) {
        int absDir;
        int otherSide = absDir = Rotation.rotateSide((int)side, (int)r);
        int otherRotation = Rotation.rotationTo((int)absDir, (int)side);
        BlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        TMultiPart part = null;
        if (tile instanceof TileMultiPart) {
            part = ((TileMultiPart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideCenter(World world, BlockPos pos, int side) {
        int otherSide = side;
        int otherRotation = -1;
        BlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        TMultiPart part = null;
        if (tile instanceof TileMultiPart) {
            part = ((TileMultiPart)tile).getSlottedPart(6);
        }
        return new FaceLookup(world, pos, side, -1, state, tile, part, pos, otherRotation, otherSide);
    }
}

