/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannelBuilder;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CoreNetwork {
    public static final ResourceLocation NET_CHANNEL = new ResourceLocation("projectred-core", "network");
    public static final int NET_TILE_PACKET_TO_CLIENT = 1;
    public static final int NET_TILE_PACKET_TO_SERVER = 3;

    public static void init() {
        PacketCustomChannelBuilder.named((ResourceLocation)NET_CHANNEL).assignClientHandler(() -> () -> new ClientHandler()).assignServerHandler(() -> () -> new ServerHandler()).build();
    }

    public static PacketCustom createTileClientPacket(IPacketReceiverTile tile, byte key) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 1);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    public static PacketCustom createTileServerPacket(IPacketReceiverTile tile, byte key) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 3);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    private static class ServerHandler
    implements ICustomPacketHandler.IServerPacketHandler {
        private ServerHandler() {
        }

        public void handlePacket(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
            switch (packet.getType()) {
                case 3: {
                    this.handleTilePacket((World)sender.func_71121_q(), (MCDataInput)packet, sender);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from client: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(World world, MCDataInput data, ServerPlayerEntity sender) {
            TileEntity tile = world.func_175625_s(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverTile) {
                ((IPacketReceiverTile)tile).receiveUpdateFromClient(key, data, sender);
            }
        }
    }

    private static class ClientHandler
    implements ICustomPacketHandler.IClientPacketHandler {
        private ClientHandler() {
        }

        public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
            switch (packet.getType()) {
                case 1: {
                    this.handleTilePacket((World)mc.field_71441_e, (MCDataInput)packet);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from server: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(World world, MCDataInput data) {
            TileEntity tile = world.func_175625_s(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverTile) {
                ((IPacketReceiverTile)tile).receiveUpdateFromServer(key, data);
            }
        }
    }
}

