/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IBundledTileInteraction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BundledSignalsLib {
    public static final int[] bundledCableBaseRotationMap = new int[]{0, 3, 3, 0, 0, 3};
    private static final List<IBundledTileInteraction> interactions = new LinkedList<IBundledTileInteraction>();

    public static void registerBundledTileInteraction(IBundledTileInteraction interaction) {
        interactions.add(interaction);
    }

    public static byte[] getBundledInput(World world, BlockPos pos, Direction facing) {
        int side = facing.ordinal();
        TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
        if (tile instanceof IBundledTile) {
            return ((IBundledTile)tile).getBundledSignal(side ^ 1);
        }
        if (tile instanceof TileMultiPart) {
            TileMultiPart tmp = (TileMultiPart)tile;
            byte[] signal = null;
            for (int r = 0; r < 4; ++r) {
                int pside = Rotation.rotateSide((int)side, (int)r);
                TMultiPart part = tmp.getSlottedPart(pside);
                if (!(part instanceof IBundledEmitter)) continue;
                int pr = Rotation.rotationTo((int)pside, (int)(side ^ 1));
                signal = BundledSignalsLib.raiseSignal(signal, ((IBundledEmitter)part).getBundledSignal(pr));
            }
            TMultiPart part = tmp.getSlottedPart(6);
            if (part instanceof IBundledEmitter) {
                signal = BundledSignalsLib.raiseSignal(signal, ((IBundledEmitter)part).getBundledSignal(side ^ 1));
            }
            return signal;
        }
        return null;
    }

    public static boolean canConnectBundledViaInteraction(World world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return interaction.canConnectBundled(world, pos, side);
        }
        return false;
    }

    public static boolean isValidInteractionFor(World world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getBundledSignalViaInteraction(World world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return interaction.getBundledSignal(world, pos, side);
        }
        return null;
    }

    public static boolean signalsEqual(byte[] signal1, byte[] signal2) {
        if (signal1 == null) {
            return BundledSignalsLib.isSignalZero(signal2);
        }
        if (signal2 == null) {
            return BundledSignalsLib.isSignalZero(signal1);
        }
        if (signal1.length != signal2.length) {
            return false;
        }
        for (int i = 0; i < signal1.length; ++i) {
            if (signal1[i] == signal2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(byte[] signal) {
        if (signal == null) {
            return true;
        }
        for (byte b : signal) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(byte[] signal, int mask) {
        if (signal == null) {
            return true;
        }
        for (int i = 0; i < signal.length; ++i) {
            if ((mask & 1 << i) == 0 || signal[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean dropSignalsLessThan(byte[] signal, byte[] threshold) {
        boolean dropped = false;
        for (int i = 0; i < 16; ++i) {
            if ((threshold[i] & 0xFF) >= (signal[i] & 0xFF)) continue;
            signal[i] = 0;
            dropped = true;
        }
        return dropped;
    }

    public static void applyChangeMask(byte[] source, byte[] dest, int mask) {
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) != 0) continue;
            dest[i] = source[i];
        }
    }

    public static byte[] raiseSignal(byte[] signal, byte[] source) {
        if (signal == null) {
            signal = new byte[16];
        }
        if (source == null) {
            return signal;
        }
        for (int i = 0; i < 16; ++i) {
            if ((signal[i] & 0xFF) >= (source[i] & 0xFF)) continue;
            signal[i] = source[i];
        }
        return signal;
    }

    public static byte[] copySignal(byte[] signal) {
        return signal == null ? null : (byte[])signal.clone();
    }

    public static void saveSignal(CompoundNBT tag, String key, byte[] signal) {
        if (signal != null) {
            tag.func_74773_a(key, signal);
        }
    }

    public static byte[] loadSignal(CompoundNBT tag, String key) {
        if (tag.func_74764_b(key)) {
            return (byte[])tag.func_74770_j(key).clone();
        }
        return null;
    }

    public static int packDigital(byte[] signal) {
        if (signal == null) {
            return 0;
        }
        int packed = 0;
        for (int i = 0; i < 16; ++i) {
            if (signal[i] == 0) continue;
            packed |= 1 << i;
        }
        return packed;
    }

    public static byte[] unpackDigital(byte[] signal, int packed) {
        if (packed == 0) {
            if (signal != null) {
                Arrays.fill(signal, (byte)0);
            }
            return signal;
        }
        if (signal == null) {
            signal = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            signal[i] = (packed & 1 << i) != 0 ? -1 : 0;
        }
        return signal;
    }

    public static int mostSignificantBit(int mask) {
        int idx = 0;
        int m2 = mask >> 1;
        while (m2 != 0) {
            m2 >>= 1;
            ++idx;
        }
        return idx;
    }

    public static String signalToString(byte[] signal) {
        if (BundledSignalsLib.isSignalZero(signal)) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append("[").append(signal[i] & 0xFF).append("]");
        }
        return sb.toString();
    }
}

