/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.compatibility;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import javax.annotation.Nonnull;
import mrtjp.projectred.api.IBundledTileInteraction;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.ProjectRedCore;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComputerCraftCompatibility {
    public static void init(Object ccModObject) {
        if (ProjectRedAPI.transmissionAPI != null) {
            ProjectRedCore.LOGGER.info("Loading Project Red ComputerCraft Compatibility Module");
            ComputerCraftAPI.registerBundledRedstoneProvider((IBundledRedstoneProvider)new CCPRBundledRedstoneProvider());
            ProjectRedAPI.transmissionAPI.registerBundledTileInteraction(new PRCCBundledTileInteraction());
        }
    }

    private static class PRCCBundledTileInteraction
    implements IBundledTileInteraction {
        private PRCCBundledTileInteraction() {
        }

        @Override
        public boolean isValidInteractionFor(World world, BlockPos pos, Direction side) {
            return ComputerCraftAPI.getBundledRedstoneOutput((World)world, (BlockPos)pos, (Direction)side) != -1;
        }

        @Override
        public boolean canConnectBundled(World world, BlockPos pos, Direction side) {
            return true;
        }

        @Override
        public byte[] getBundledSignal(World world, BlockPos pos, Direction side) {
            int signal = ComputerCraftAPI.getBundledRedstoneOutput((World)world, (BlockPos)pos, (Direction)side);
            return BundledSignalsLib.unpackDigital(null, signal);
        }
    }

    private static class CCPRBundledRedstoneProvider
    implements IBundledRedstoneProvider {
        private CCPRBundledRedstoneProvider() {
        }

        public int getBundledRedstoneOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
            byte[] signal = ProjectRedAPI.transmissionAPI.getBundledInput(world, pos.func_177972_a(side), side.func_176734_d());
            return BundledSignalsLib.packDigital(signal);
        }
    }
}

