/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderProvider;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderContext;

public final class PlayerTrackerMenuRenderer
extends MapElementMenuRenderer<PlayerTrackerMapElement<?>, PlayerTrackerMenuRenderContext> {
    private final PlayerTrackerIconRenderer iconRenderer;
    private final PlayerTrackerMapElementRenderer renderer;
    private Button showPlayersButton;

    private PlayerTrackerMenuRenderer(PlayerTrackerMapElementRenderer renderer, PlayerTrackerIconRenderer iconRenderer, PlayerTrackerMenuRenderContext context, PlayerTrackerMapElementRenderProvider<PlayerTrackerMenuRenderContext> provider) {
        super(context, provider);
        this.iconRenderer = iconRenderer;
        this.renderer = renderer;
    }

    @Override
    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        super.onMapInit(screen, mc, width, height);
        CursorBox showPlayersTooltip = new CursorBox((ITextComponent)new TranslationTextComponent(WorldMap.settings.trackedPlayers ? "gui.xaero_box_showing_tracked_players" : "gui.xaero_box_hiding_tracked_players", new Object[]{new StringTextComponent(Misc.getKeyName(screen.getTrackedPlayerKeyBinding())).func_240700_a_(s -> s.func_240712_a_(TextFormatting.DARK_GREEN))}), true);
        this.showPlayersButton = new GuiTexturedButton(width - 173, height - 33, 20, 20, WorldMap.settings.trackedPlayers ? 197 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onShowPlayersButton(screen, width, height), () -> showPlayersTooltip);
        screen.func_230480_a_(this.showPlayersButton);
    }

    public void onShowPlayersButton(GuiMap screen, int width, int height) {
        WorldMap.settings.trackedPlayers = !WorldMap.settings.trackedPlayers;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_231158_b_(this.mc, width, height);
        screen.func_231035_a_((IGuiEventListener)this.showPlayersButton);
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }

    @Override
    public void renderInMenu(PlayerTrackerMapElement<?> element, MatrixStack matrixStack, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        PlayerTrackerMapElement<?> playerElement = element;
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(playerElement.getPlayerId());
        if (info != null) {
            PlayerEntity clientPlayer = mc.field_71441_e.func_217371_b(playerElement.getPlayerId());
            this.iconRenderer.renderIcon(matrixStack, clientPlayer, this.renderer.getTrackedPlayerIconManager().getPlayerSkin(clientPlayer, info));
        }
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 1;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_players_by_name";
    }

    @Override
    protected MapElementRenderer<? super PlayerTrackerMapElement<?>, ?, ?> getRenderer(PlayerTrackerMapElement<?> element) {
        return this.renderer;
    }

    public static final class Builder {
        private PlayerTrackerMapElementRenderer renderer;

        private Builder() {
        }

        private Builder setDefault() {
            this.setRenderer(null);
            return this;
        }

        public Builder setRenderer(PlayerTrackerMapElementRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public PlayerTrackerMenuRenderer build() {
            if (this.renderer == null) {
                throw new IllegalStateException();
            }
            return new PlayerTrackerMenuRenderer(this.renderer, new PlayerTrackerIconRenderer(), new PlayerTrackerMenuRenderContext(), new PlayerTrackerMapElementRenderProvider(this.renderer.getCollector()));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

