/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.tracker;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import xaero.map.WorldMapSession;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;

public class ClientboundTrackedPlayerPacket
extends WorldMapMessage<ClientboundTrackedPlayerPacket> {
    private final boolean remove;
    private final UUID id;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, ResourceLocation dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("r", this.remove);
        nbt.func_186854_a("i", this.id);
        if (!this.remove) {
            nbt.func_74780_a("x", this.x);
            nbt.func_74780_a("y", this.y);
            nbt.func_74780_a("z", this.z);
            nbt.func_74778_a("d", this.dimension.toString());
        }
        buffer.func_150786_a(nbt);
    }

    public static ClientboundTrackedPlayerPacket read(PacketBuffer buffer) {
        CompoundNBT nbt = buffer.func_244273_m();
        boolean remove = nbt.func_74767_n("r");
        UUID id = nbt.func_186857_a("i");
        double x = remove ? 0.0 : nbt.func_74769_h("x");
        double y = remove ? 0.0 : nbt.func_74769_h("y");
        double z = remove ? 0.0 : nbt.func_74769_h("z");
        String dimensionString = remove ? null : nbt.func_74779_i("d");
        ResourceLocation dimension = dimensionString == null ? null : new ResourceLocation(dimensionString);
        return new ClientboundTrackedPlayerPacket(remove, id, x, y, z, dimension);
    }

    public static class Handler
    implements ClientMessageConsumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void handle(ClientboundTrackedPlayerPacket t) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            if (t.remove) {
                session.getMapProcessor().getClientSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            session.getMapProcessor().getClientSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, t.dimension);
        }
    }
}

