/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.ScreenBase;
import xaero.map.world.MapDimension;

public class GuiMapName
extends ScreenBase {
    private TextFieldWidget nameTextField;
    private MapDimension mapDimension;
    private String editingMWId;
    private String currentNameFieldContent;
    private MapProcessor mapProcessor;

    public GuiMapName(MapProcessor mapProcessor, Screen par1GuiScreen, Screen escape, MapDimension mapDimension, String editingMWId) {
        super(par1GuiScreen, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_map_name"));
        this.mapDimension = mapDimension;
        this.editingMWId = editingMWId;
        this.currentNameFieldContent = editingMWId == null ? "" : mapDimension.getMultiworldName(editingMWId);
        this.mapProcessor = mapProcessor;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.nameTextField != null) {
            this.currentNameFieldContent = this.nameTextField.func_146179_b();
        }
        this.nameTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 60, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_map_name"));
        this.nameTextField.func_146180_a(this.currentNameFieldContent);
        this.func_231035_a_((IGuiEventListener)this.nameTextField);
        this.nameTextField.func_146195_b(true);
        this.field_230705_e_.add(this.nameTextField);
        this.func_230480_a_((Widget)new MySmallButton(this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            if (this.canConfirm()) {
                Object object = this.mapProcessor.uiSync;
                synchronized (object) {
                    if (this.mapProcessor.getMapWorld() == this.mapDimension.getMapWorld()) {
                        String mwIdFixed;
                        String unfilteredName = this.nameTextField.func_146179_b();
                        if (this.editingMWId == null) {
                            String mwId = unfilteredName.toLowerCase().replaceAll("[^a-z0-9]+", "");
                            if (mwId.isEmpty()) {
                                mwId = "map";
                            }
                            mwId = "cm$" + mwId;
                            boolean mwAdded = false;
                            mwIdFixed = mwId;
                            int fix = 1;
                            while (!mwAdded) {
                                mwAdded = this.mapDimension.addMultiworldChecked(mwIdFixed);
                                if (mwAdded) continue;
                                mwIdFixed = mwId + ++fix;
                            }
                            Path dimensionFolderPath = this.mapDimension.getMainFolderPath();
                            Path multiworldFolderPath = dimensionFolderPath.resolve(mwIdFixed);
                            try {
                                Files.createDirectories(multiworldFolderPath, new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                            }
                            this.mapDimension.setMultiworldUnsynced(mwIdFixed);
                        } else {
                            mwIdFixed = this.editingMWId;
                        }
                        this.mapDimension.setMultiworldName(mwIdFixed, unfilteredName);
                        this.mapDimension.saveConfigUnsynced();
                        this.goBack();
                    }
                }
            }
        }));
        this.func_230480_a_((Widget)new MySmallButton(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private boolean canConfirm() {
        return this.nameTextField.func_146179_b().length() > 0;
    }

    private void updateConfirmButton() {
        ((Button)this.field_230710_m_.get((int)0)).field_230693_o_ = this.canConfirm();
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        boolean result = super.func_231046_a_(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            ((Widget)this.field_230710_m_.get(0)).func_230982_a_(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void func_231023_e_() {
        this.updateConfirmButton();
        this.nameTextField.func_146178_a();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        this.func_230446_a_(matrixStack);
        GuiMapName.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        this.nameTextField.func_230430_a_(matrixStack, par1, par2, par3);
        super.func_230430_a_(matrixStack, par1, par2, par3);
    }
}

